/* 
   EODatabase.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EODatabase_h__
#define __EODatabase_h__

#include <Foundation/NSObject.h>

@class NSArray;
@class NSMutableArray;
@class NSDictionary;
@class NSMutableDictionary;
@class NSString;
@class NSMutableString;

@class EOAdaptor;
@class EOModel;
@class EOEntity;

@class EOObjectUniquer;
@class EODatabase;
@class EODatabaseContext;
@class EODatabaseChannel;

@interface EODatabase : NSObject
{
    EOAdaptor*		adaptor;
    EOObjectUniquer*	objectsDictionary;
    NSMutableArray*	contexts;
    
    struct {
	BOOL		isUniquingObjects:1;
	BOOL		isKeepingSnapshots:1;
	BOOL		isLoggingWarnings:1;
    } flags;
}

// Initializing new instances
- initWithAdaptor:(EOAdaptor*)anAdaptor;
- initWithModel:(EOModel*)aModel;

// Getting the adaptor
- (EOAdaptor*)adaptor;

// Getting the database contexts
- createContext;
- (NSArray*)contexts;

// Checking connection status
- (BOOL)hasOpenChannels;

// Uniquing/snapshotting
- (void)setUniquesObjects:(BOOL)yn;
- (BOOL)uniquesObjects;
- (void)setKeepsSnapshots:(BOOL)yn;
- (BOOL)keepsSnapshots;

// Handle Objects
+ (void)forgetObject:anObj;
- (void)forgetObject:anObj;
- (void)forgetAllObjects;
- (void)forgetAllSnapshots;
- objectForPrimaryKey:(NSDictionary*)aKey
  entity:(EOEntity*)anEntity;
- (NSDictionary*)snapshotForObject:anObj;
- (NSDictionary*)primaryKeyForObject:anObj;
- (void)primaryKey:(NSDictionary**)aKey
  andSnapshot:(NSDictionary**)aSnapshot
  forObject:anObj;
- (void)recordObject:anObj
  primaryKey:(NSDictionary*)aKey 
  snapshot:(NSDictionary*)aSnapshot;
- (void)recordObject:anObj
  primaryKey:(NSDictionary*)aKey
  entity:(EOEntity*)anEntity
  snapshot:(NSDictionary*)aSnapshot;
- (BOOL)isObject:anObj updatedOutsideContext:(EODatabaseContext*)aContext;

// Error messages
- (BOOL)logsErrorMessages;
- (void)setLogsErrorMessages:(BOOL)yn;
- (void)reportError:(NSString*)error;
- (void)reportErrorFormat:(NSString*)format, ...;
- (void)reportErrorFormat:(NSString*)format arguments:(va_list)arguments;

@end /* EODatabase */

/*
 * Methods used by database classess internally
 */

@interface EODatabase(Private)
- (void)contextDidInit:aContext;
- (void)contextWillDealloc:aContext;
- (EOObjectUniquer*)objectUniquer;
@end

#endif /* __EODatabase_h__ */
