/* 
   EODatabaseDataSource.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EODatabaseDataSource_h__
#define __EODatabaseDataSource_h__

#include <Foundation/NSObject.h>
#include <eoaccess/EODataSources.h>

@class NSArray;
@class EODatabaseChannel;
@class EOEntity;
@class EOQualifier;

@interface EODatabaseDataSource : NSObject 
<EOMasterDataSources, EOQualifiableDataSources, EORollbackDataSources>
{
    EODatabaseChannel*	databaseChannel;
    EOQualifier*	qualifier;
    EOQualifier*	auxiliaryQualifier;
    NSArray*		fetchOrder;
    
    NSString*		dataBaseName;
    NSString*		dataBaseContextName;
    NSString*		dataBaseChannelName;
    
    // These should be bitfield but are left so for debugging
    
    BOOL		isInitializedInRendesvous;
    BOOL		isConnected;
    BOOL		isFetchEnabled;
    BOOL		isAutoTransactionEnabled;
    BOOL		isInAutoTransaction;
}

// Database objects rendesvous 
+ (void)registerChannel:(EODatabaseChannel*)channel 
  forRendezvousWithDatabaseName:(NSString*)aDatabaseName 
  contextName:(NSString*)aContextName 
  channelName:(NSString*)aChannelName;
+ (EODatabaseChannel*)databaseChannelWithDatabaseName:(NSString*)aDatabaseName 
  contextName:(NSString*)aContextName 
  channelName:(NSString*)aChannelName;
+ (void)releaseObjectsWithDatabaseName:(NSString*)aDatabaseName 
  contextName:(NSString*)aContextName 
  channelName:(NSString*)aChannelName;
+ (EODatabaseChannel*)channelForRendezvousWithModelName:(NSString*)aModelName
  databaseName:(NSString*)aDatabaseName 
  contextName:(NSString*)aContextName 
  channelName:(NSString*)aChannelName;

// Initializing instances
- initWithDatabaseChannel:(EODatabaseChannel*)aChannel
  entity:(EOEntity*)anEntity;
- initWithDatabaseChannel:(EODatabaseChannel*)aChannel
  entityNamed:(NSString*)entityName;
- initWithModelName:(NSString*)modelName
  entityName:(NSString*)entityName;
- initWithModelName:(NSString*)modelName
  entityName:(NSString*)entityName
  databaseName:(NSString*)databaseName
  contextName:(NSString*)contextName
  channelName:(NSString*)channelName;

// Getting the database channel
- (EODatabaseChannel*)databaseChannel;

// Getting the root entity	
- (EOEntity*)entity;

// Setting automatic transaction control
- (void)setBeginsTransactionsAutomatically:(BOOL)flag;
- (BOOL)beginsTransactionsAutomatically;

// Setting the qualifier
- (void)setQualifier:(EOQualifier*)aQualifier;
- (EOQualifier*)qualifier;
- (void)setAuxiliaryQualifier:(EOQualifier*)aQualifier;
- (EOQualifier*)auxiliaryQualifier;
- (EOQualifier*)qualifierForFetch;

// Enabling fetching
- (void)setFetchEnabled:(BOOL)flag;
- (BOOL)isFetchEnabled;

// Setting the fetch order
- (void)setFetchOrder:(NSArray*)fetchOrder;
- (NSArray*)fetchOrder;

@end /* EODataSource */

#endif /* __EODatabaseDataSource_h__ */
