/* 
   EOEntity.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: August 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __EOEntity_h__
#define __EOEntity_h__

#include <Foundation/NSString.h>
#include <extensions/GCObject.h>
#include <extensions/GCArray.h>
#include <extensions/GCDictionary.h>

@class EOModel;
@class EOAttribute;
@class EORelationship;
@class EOQualifier;
@class EOExpressionArray;

@interface EOEntity : GCObject
{
    NSString*		name;
    NSString*		className;
    NSString*		externalName;
    NSString*		externalQuery;
    NSDictionary*	userDictionary;
    NSArray*		primaryKeyAttributeNames;
    NSArray*		attributesNamesUsedForInsert;
    NSArray*		classPropertyNames;

    /* Garbage collectable objects */
    EOModel*		model;
    EOQualifier*	qualifier;
    GCArray*		attributes;
    GCMutableDictionary* attributesByName;
    GCArray*		relationships;
    GCMutableDictionary* relationshipsByName;	  // name/EORelationship
    GCArray*		primaryKeyAttributes;
    GCArray*		classProperties; 	  // EOAttribute/EORelationship
    GCArray*		attributesUsedForLocking;

    /* Cached properties */
    GCArray*		attributesUsedForInsert;  // cache from classProperties
    GCArray*		attributesUsedForFetch;   // cache from classProperties
    GCArray*		relationsUsedForFetch;    // cache from classProperties

    struct {
	BOOL isReadOnly:1;
	BOOL createsMutableObjects:1;
	BOOL isPropertiesCacheValid:1;
    } flags;
}

/* Initializing instances */
- initWithName:(NSString*)name;

/* Accessing the name */
- (NSString*)name;
- (BOOL)setName:(NSString*)name;
+ (BOOL)isValidName:(NSString*)name;

/* Accessing the model */
- (void)setModel:(EOModel*)model;
- (EOModel*)model;

/* Getting the qualifier */
- (EOQualifier*)qualifier;

/* Accessing attributes */
- (BOOL)addAttribute:(EOAttribute*)attribute;
- (void)removeAttributeNamed:(NSString*)name;
- (EOAttribute*)attributeNamed: (NSString*)attributeName;
- (NSArray*)attributes;

/* Accessing relationships */
- (BOOL)addRelationship:(EORelationship*)relationship;
- (void)removeRelationshipNamed:(NSString*)name;
- (EORelationship*)relationshipNamed: (NSString*)relationshipName;
- (NSArray*)relationships;

/* Accessing primary key attributes */
- (BOOL)setPrimaryKeyAttributes: (NSArray*)keys;
- (NSArray*)primaryKeyAttributes;
- (NSArray*)primaryKeyAttributeNames;
- (BOOL)isValidPrimaryKeyAttribute: (EOAttribute*)anAttribute;

/* Getting primary keys and snapshot for row */
- (NSDictionary*)primaryKeyForRow:(NSDictionary*)row;
- (NSDictionary*)snapshotForRow:(NSDictionary*)aRow;

/* Getting attributes used for fetch/insert/update operations */
- (NSArray*)attributesUsedForInsert;
- (NSArray*)attributesUsedForFetch;
- (NSArray*)relationsUsedForFetch;
- (NSArray*)attributesNamesUsedForInsert;

/* Accessing class properties */
- (BOOL)setClassProperties: (NSArray*)properties;
- (NSArray*)classProperties;
- (NSArray*)classPropertyNames;
- (BOOL)isValidClassProperty:aProp;
- (id)propertyNamed:(NSString*)name;

/* Accessing locking attributes */
- (BOOL)setAttributesUsedForLocking: (NSArray*)attributes;
- (NSArray*)attributesUsedForLocking;
- (BOOL)isValidAttributeUsedForLocking:(EOAttribute*)anAttribute;

/* Accessing the enterprise object class */
- (void)setClassName:(NSString*)name;
- (NSString*)className; 

/* Accessing external information */
- (void)setExternalName:(NSString*)name;
- (NSString*)externalName;

/* Accessing the external query */
- (void)setExternalQuery:(NSString*)query;
- (NSString*)externalQuery;

/* Accessing read-only status */
- (void)setReadOnly:(BOOL)flag;
- (BOOL)isReadOnly;

/* Accessing the user dictionary */
- (NSDictionary*)userDictionary;
- (void)setUserDictionary:(NSDictionary*)dictionary;

- (BOOL)referencesProperty:property;

@end


@interface EOEntity (EOEntityPrivate)

+ (EOEntity*)entityFromPropertyList:(id)propertyList model:(EOModel*)model;
- (void)replaceStringsWithObjects;

- (id)propertyList;
- (void)setCreateMutableObjects:(BOOL)flag;
- (BOOL)createsMutableObjects;

- (void)validatePropertiesCache;
- (void)invalidatePropertiesCache;

@end

@interface EOEntity(ValuesConversion)

- (NSDictionary*)convertValuesToModel:(NSDictionary*)aRow;

@end /* EOAttribute (ValuesConversion) */

#endif /* __EOEntity_h__ */
