/* 
   EOFaultResolver.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef		__EOFaultResolver_h__
#define		__EOFaultResolver_h__

@class EOFault;
@class EODatabaseChannel;
@class EOQualifier;
@class EOEntity;

@interface EOFaultResolver : NSObject
{
    @public
    int faultReferences;
    Class targetClass;
    EOFault* fault;
    EODatabaseChannel* channel;
    NSZone* zone;
}

- initWithDatabaseChannel:(EODatabaseChannel*)aChannel
  zone:(NSZone*)zone  
  targetClass:(Class)targetClass 
  fault:fault;

- (BOOL)beforeFault;
- (BOOL)fault;
- (BOOL)afterFault;

- (Class)targetClass;
- (NSDictionary*)primaryKey;
- (EOEntity*)entity;
- (EOQualifier*)qualifier;
- (NSArray*)fetchOrder;
- (EODatabaseChannel*)databaseChannel;

@end /* EOFaultResolver */

@interface EOArrayFault : EOFaultResolver
{
    EOQualifier* qualifier;
    NSArray* fetchOrder;
}

- initWithQualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder 
  databaseChannel:(EODatabaseChannel*)channel 
  zone:(NSZone*)zone  
  targetClass:(Class)targetClass 
  fault:fault;

- (BOOL)fault;

- (EOEntity*)entity;
- (EOQualifier*)qualifier;
- (NSArray*)fetchOrder;

@end

@interface EOObjectFault : EOFaultResolver
{
    EOEntity* entity;
    NSDictionary* primaryKey;
}

- initWithPrimaryKey:(NSDictionary*)key
  entity:(EOEntity*)entity 
  databaseChannel:(EODatabaseChannel*)channel 
  zone:(NSZone*)zone  
  targetClass:(Class)targetClass 
  fault:fault;

- (BOOL)fault;

- (NSDictionary*)primaryKey;
- (EOEntity*)entity;

@end

#endif		/* __EOFaultResolver_h__ */
