/* 
   Postgres95SQLExpression.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
	      based on the Sybase Adaptor written by 
	   Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Date: December 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <Foundation/NSUtilities.h>

#include <extensions/NSException.h>

#include <eoaccess/EOEntity.h>
#include <eoaccess/EORelationship.h>
#include <eoaccess/EOAttribute.h>
#include <eoaccess/EOAttributeOrdering.h>

#include <eoadaptors/Postgres95/Postgres95Exceptions.h>
#include <eoadaptors/Postgres95/Postgres95SQLExpression.h>

@implementation Postgres95SQLExpression

+ (Class)selectExpressionClass
{
    return [Postgres95SelectSQLExpression class];
}

@end /* Postgres95SQLExpression */


@implementation Postgres95SelectSQLExpression

- selectExpressionForAttributes:(NSArray*)attributes
  lock:(BOOL)flag
  qualifier:(EOQualifier*)qualifier
  fetchOrder:(NSArray*)fetchOrder
  channel:(EOAdaptorChannel*)channel
{
    lock = flag;
    [super selectExpressionForAttributes:attributes
	   lock:flag
	   qualifier:qualifier
	   fetchOrder:fetchOrder
	   channel:channel];
    return self;
}

- (NSString*)fromClause
{
    NSMutableString* fromClause
	    = [NSMutableString stringWithCString:"\nFROM "];
    NSEnumerator* enumerator = [fromListEntities objectEnumerator];
    BOOL first = YES;
    id key;

    /* Compute the FROM list from all the aliases found in
       entitiesAndPropertiesAliases dictionary. Note that this dictionary
       contains entities and relationships. The last ones are there for
       flattened attributes over reflexive relationships. */
    while((key = [enumerator nextObject])) {
	if(first)
	    first = NO;
	else
	    [fromClause appendString:@", "];

	if([key isKindOfClass:[EORelationship class]]) {
	    /* This key corresponds to a flattened attribute. */
	    [fromClause appendFormat:@"%@ %@",
			    [[key destinationEntity] externalName],
			    [entitiesAndPropertiesAliases objectForKey:key]];
	    /* xxx HOLDLOCK doesn't work! */
#if 0
	    if (lock)
		[fromClause appendString:@" HOLDLOCK"];
#endif
	}
	else {
	    /* This is an EOEntity. */
	    [fromClause appendFormat:@"%@ %@",
			    [key externalName],
			    [entitiesAndPropertiesAliases objectForKey:key]];
	    /* xxx HOLDLOCK doesn't work! */
#if 0
	    if (lock)
		[fromClause appendString:@" HOLDLOCK"];
#endif
	}
    }

    return fromClause;
}

/*
 *  Server does not accept table aliases and ASC/DESC in ORDER BY
 *  only ascending seems to be supported.
 */

- (NSString*)orderByClauseForFetchOrder:(NSArray*)fetchOrder
{
    int i, count = [fetchOrder count];
    NSMutableString* orderBy;
    BOOL first = YES;

    if(!count)
	return @"";

    orderBy = (id)[NSMutableString stringWithCString:"\nORDER BY "];
    for(i = 0; i < count; i++) {
	EOAttributeOrdering* order = [fetchOrder objectAtIndex:i];
	EOOrdering ordering = [order ordering];

	if (ordering == EODescendingOrder)
	    THROW([[Postgres95Exception alloc] initWithFormat:
		@"Postgres95 does not support DESC[ENDING] in ORDER BY"]);
	    
	if (ordering == EODescendingOrder)
	    continue;
	
	if (first)
	    first = NO;
	else
	    [orderBy appendString:@", "];
	
	[orderBy appendFormat:@"%@", [[order attribute] columnName]];
    }

    return orderBy;
}

@end /* Postgres95SelectSQLExpression */
