/* 
   SQLServerChannel.h

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>
   Author: Scott Christley <scottc@net-community.com>
   Date: October 1996

   Portions of the code were inspired by a database access library written by
   Stefan Popescu <fane@xpro.pcnet.ro>.

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __SQLServerChannel_h__
#define __SQLServerChannel_h__

#include <eoaccess/EOAdaptorChannel.h>
#include "SQLServerAdaptor.h"

@class NSMutableDictionary;
@class NSMutableArray;
@class EOAttribute;

typedef enum
{
    SQLServerInvalidRowType = -1,
    SQLServerRegularRow,
    SQLServerComputeRow,
    SQLServerReturnParameterRow,
    SQLServerReturnStatusRow
} SQLServerRowType;

typedef enum
{
    SQLServerRowFetch,
    SQLServerReturnParameterFetch,
    SQLServerReturnStatusFetch,
    SQLServerTerminatedFetch
} SQLServerFetchState;

@interface SQLServerChannel : EOAdaptorChannel
{
    SQLServerAdaptor* adaptor;
    DBPROCESS* dbProcess;
    id sqlExpression;
    SQLServerRowType rowType;
    SQLServerFetchState fetchState;
    int computeRowId;
    int rowsAffected;
    struct {
	BOOL sqlserverWillFetchAttributes:1;
	BOOL sqlserverWillReturnRow:1;
    } sqlserverDelegateRespondsTo;
}

- (DBPROCESS*)dbProcess;

/* Private methods */
- (void)_advanceRow;
- (BOOL)_modifyBinaryDataRow:(NSMutableDictionary*)binaryDataRow
  ordinaryDataRow:(NSMutableDictionary*)mrow
  binaryDataAttributes:(NSMutableArray*)binaryDataAttributes
  forEntity:(EOEntity*)entity;
- (BOOL)_updateBinaryDataRow:(NSMutableDictionary*)binaryDataRow
  binaryDataAttributes:(NSMutableArray*)binaryDataAttributes
  qualifier:(EOQualifier*)qualifier;
@end


@interface NSObject (SQLServerChannelDelegate)

- (NSArray*)sqlserverChannel:(SQLServerChannel*)channel
  willFetchAttributes:(NSArray*)attributes
  forRowOfType:(SQLServerRowType)rowType
  withComputeRowId:(int)computeRowId;

- (BOOL)sqlserverChannel:(SQLServerChannel *)channel
    willReturnRow:(NSDictionary *)row
    ofType:(SQLServerRowType)rowType 
    withComputeRowId:(int)computeRowId;

@end

#endif /* __SQLServerChannel_h__ */
