/* 
   EOControllerPrivate.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author: Mircea Oancea <mircea@jupiter.elcom.pub.ro>
   Date: November 1996

   This file is part of the GNUstep Database Library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <eoaccess/common.h>

#if NeXT_foundation_LIBRARY
typedef void NXTypedStream;
#endif

#include <Foundation/NSString.h>
#include "EOControllerPrivate.h"

/*
 * _EOOperation
 */

@implementation _EOOperation

- initOperation:(_EOControllerOperation)op onObject:obj new:new old:old
{
	operation = op;
	object = [obj retain];
	newvalues = [new retain];
	oldvalues = [old retain];
	return self;
}

- initOperation:(_EOControllerOperation)op onObject:obj index:(int)ind
{
	operation = op;
	object = [obj retain];
	index = ind;
	return self;
}

- (void)dealloc
{
	[object release];
	[newvalues release];
	[oldvalues release];
	[super dealloc];
}

- (NSString*)description
{
	NSString*	ops[4] = {@"Update", @"Insert", @"Delete", @"RollBack"};
	return [NSString stringWithFormat:@"EOOperation:%@ object:%08x index:%d",
		ops[operation], (int)object, index];
}

- (void)setOperation:(_EOControllerOperation)op
{
	operation = op;
}

- (_EOControllerOperation)operation
{
	return operation;
}

- (id)object
{
	return object;
}

- (id)newvalues
{
	return newvalues;
}

- (id)oldvalues
{
	return oldvalues;
}

- (int)index 
{
	return index;
}

@end /* _EOOperation */

/*
 * _EOUndoGroup
 */
 
@implementation _EOUndoGroup

- init
{
	stack = [[NSMutableArray alloc] init];
	return self;
}

- (void)dealloc
{
	[stack release];
	[super dealloc];
}

- (void)pushController:ctrl
{
	[stack addObject:[NSValue valueWithNonretainedObject:ctrl]];
}

- (id)popController
{
	id ctrl = nil;
	int ind = [stack count]-1;
	if (ind>=0) 
	{
		ctrl = [[stack objectAtIndex:ind] nonretainedObjectValue];
		[stack removeObjectAtIndex:ind];
	}
	return ctrl;
}

- (void)removeController:ctrl
{
	int i;
	for (i = [stack count] -1; i>=0; i--) 
	{
		if (ctrl == [[stack objectAtIndex:i] nonretainedObjectValue])
			[stack removeObjectAtIndex:i];
	}
}

- (void)removeAllControllers
{
	[stack removeAllObjects];
}

- (BOOL)hasUndos
{
	return [stack count] ? YES : NO;
}

@end /* _EOUndoGroup */
