/* 
   MissingMethods.m

   Copyright (C) 1995, 1996, 1997 Ovidiu Predescu and Mircea Oancea.
   All rights reserved.

   Author: Ovidiu Predescu <ovidiu@bx.logicnet.ro>

   This file is part of the Foundation Extensions Library.

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose and without fee is hereby granted, provided
   that the above copyright notice appear in all copies and that both that
   copyright notice and this permission notice appear in supporting
   documentation.

   We disclaim all warranties with regard to this software, including all
   implied warranties of merchantability and fitness, in no event shall
   we be liable for any special, indirect or consequential damages or any
   damages whatsoever resulting from loss of use, data or profits, whether in
   an action of contract, negligence or other tortious action, arising out of
   or in connection with the use or performance of this software.
*/

#import <Foundation/NSString.h>

#include <extensions/MissingMethods.h>
#include <extensions/common.h>
#include <extensions/objc-runtime.h>
#include <extensions/NSException.h>
#include <extensions/exceptions/GeneralExceptions.h>

void __MissingMethods_dummy_function_for_stupid_linkers()
{
}

#if GNUSTEP_BASE_LIBRARY

@implementation NSArray (AdditionalMethods)
- initWithArray:(NSArray *)anArray copyItems:(BOOL)flag
{
  if (!flag)
    return [self initWithArray: anArray];
  else
    {
      // We should create copies of the objects here
      return [self initWithArray: anArray];
    }
}
@end

#endif /* GNUSTEP_BASE_LIBRARY */



#if NeXT_Foundation_LIBRARY || Sun_Foundation_LIBRARY

@implementation NSObject (MissingMethods)
/* Not really missing, but these methods are useful at least in the earliear
    stages of development :-) */
- subclassResponsibility:(SEL)aSel
{
    id exception = [[ObjcRuntimeException alloc]
			    initWithFormat:@"subclass should override %s",
			    sel_get_name(aSel)];
    THROW(exception);
    return self;
}

- notImplemented:(SEL)aSel
{
    id reason = [NSString stringWithFormat:@"%s does not implement %s",
			    object_get_class_name(self), sel_get_name(aSel)];
    id exception = [[ObjcRuntimeException alloc]
			initWithName:@"ObjcRuntimeException"
			reason:reason userInfo:nil];
    THROW(exception);
    return self;
}
@end /* NSObject (MissingMethods) */

#endif /* NeXT_Foundation_LIBRARY || Sun_Foundation_LIBRARY */
