/* 
   PXKTestImage.m

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Pascal Forget <pascal@wsc.com>
   Date: October 1995
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "config.h"
#include <gnustep/xdps/PXKTestImage.h>
#include <gnustep/xdps/PXKScreen.h>

NSMutableArray *_pxkImages = nil;

@implementation PXKTestImage

#if 0
+ imageNamed:(const char *)str;
{
    int i, count = [_pxkImages count];
    id image;

#if 0    
    fprintf(stdout, "images: %d\n", count);
#endif
    
    for (i=0; i<count; i++) {
	image = [_pxkImages objectAtIndex:i];
	if (!strcmp((const char *)[image name], str)) {
	    return image;
	}
    }
    puts("PXKImage imageNamed: Image not found\n");
    return nil;				  
}

+ initialize;
{
    if (!_pxkImages) {
	_pxkImages = [[NSMutableArray alloc] initWithCapacity:15];
    }
    
    return self;
}

- drawInView:(PXKView *)view at:(NSPoint)location;
{
    NSPoint p = location;

    XPutImage(pxkDisplay, [view xWindow], pxkBlackGC, xImage,
	      0, 0, p.x, p.y, frame.size.width, frame.size.height);

    return self;
}

- buildImageFromString:(const char *)image;
{
    char buf[15];
    int  version;
    int  width;
    int  height;
    int  x, y;
    char pixel;
    XColor c1, c2;
    unsigned int white = WhitePixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]);
    unsigned int lightgray;
    unsigned int darkgray;
    unsigned int black = BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]);

    strncpy(buf, image+12, 4);
    width = atoi(buf);

    strncpy(buf, image+16, 4);
    height = atoi(buf);

#if 0
    fprintf(stdout, "width: %d  height: %d\n", width, height);
#endif
    
    XAllocNamedColor(pxkDisplay,
		     XDefaultColormap(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]),
		     "light gray", &c1, &c2);

    lightgray = c1.pixel;
    
    XAllocNamedColor(pxkDisplay,
		     XDefaultColormap(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]),
		     "dark gray", &c1, &c2);

    darkgray = c1.pixel;

    for (y=0; y<height; y++) {
	for (x=0; x<width; x++) {

	    pixel = image[20 + x + y*width]; 
#if 0
	    fprintf(stdout, "%c", pixel);
#endif
	    switch(pixel) {
	      case 'g': XPutPixel(xImage, x, y, lightgray); break;
	      case 'b': XPutPixel(xImage, x, y, black); break;
	      case 'G': XPutPixel(xImage, x, y, darkgray); break;
	      case 'w': XPutPixel(xImage, x, y, white); break;
	      default: break;
	    }
	}
#if 0
	fprintf(stdout, "\n");
#endif
    }
    return self;
}
    
- initWithSize:(NSSize)initialSize;
{
    int x, y;
    XColor c1, c2;
    NSSize si = initialSize;

    [super init];
    size = si;

#if 0    
    puts("PXKImage: initWithSize:");
#endif
    
    /*
     * This is the only way I found to reliably create an x image.
     */    
    xImage = XGetImage(pxkDisplay, RootWindow(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]),
		       0,0, size.width, size.height, AllPlanes, XYPixmap);


#if 0
/*
     * Fill the image with the default color, lightgray
     */
    XAllocNamedColor(pxkDisplay,
		     XDefaultColormap(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]),
		     "light gray", &c1, &c2);

    for (x=0; x<size.width; x++) {
	for (y=0; y<size.height; y++) {
	    XPutPixel(xImage, x, y, c1.pixel);
	}
    }
    
    XPutPixel(xImage, 5,5, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 5,6, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 5,7, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 5,8, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 6,5, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 6,6, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 6,7, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 6,8, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 7,5, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 7,6, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 7,7, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
    XPutPixel(xImage, 7,8, BlackPixel(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]));
#endif
    
    [_pxkImages addObject:self];    
    
    return self;
}

- initFromBitmap:(char *)bits size:(NSSize)newSize;
{
    NSSize si = newSize;

    [super init];
    size = si;
  
    /* See X book number 1, page 157-158 */    

    fprintf(stdout, "w: %d h:%d\n", size.width, size.height);
#if 0
    xPixmap = XCreateBitmapFromData(pxkDisplay,
				    RootWindow(pxkDisplay, [(PXKScreen *)[NSScreen mainScreen] xScreen]),
				    _pxkRightArrow_bitmap,
				    15, 15);
#endif
    puts("Pixmap created");
    
    [_pxkImages addObject:self];    
    puts("image added");
    return self;
}
    
- initFromPath:(const char *)filename size:(NSSize)newSize;
{
    NSSize si = newSize;
    size = si;

    /* Not implemented, see X book number 1, page 157-158 */
    
    [_pxkImages addObject:self];
    return self;
}

- (const char *)name;
{
    return name;
}

- setName:(const char *)newName;
{
    if (name != NULL) {
	free(name);
    }

    if (newName != NULL) {
	name = (char *)malloc(strlen(newName) + 1);
	strcpy(name, newName);
    }

    return self;
}

- (NSSize)size;
{
    return size;
}

- (XImage *)xImage;
{
    return xImage;
}
#endif

@end
