/* 
   IMModelView.m

   Model view used for moving, sizing, and editing of visual components.

   Copyright (C) 1996, 1997 Free Software Foundation, Inc.

   Author: Scott Christley <scottc@net-community.com>
   Date: October 1996
   
   This file is part of the GNUstep Interface Modeller.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <AppKit/AppKit.h>

#include "IMModelWindow.h"
#include "IMModelView.h"


@implementation IMModelView

//
// Instance methods
//
- (void)display
{
id e;
NSView *o;
NSColor *c = [NSColor blackColor];

  [super display];

fprintf(stderr, " IMModelView display\n");

  [self lockFocus];
  e = [[(IMModelWindow *)window selectedElements] objectEnumerator];
  o = (NSView *)[e nextObject];
  while (o)
    {
      NSRect r = [o frame];
      NSRect h;
      float mid;

      [c set];
      h.size.width = 6;
      h.size.height = 6;

      // Display handles on corners

      // Bottom left
      h.origin.x = r.origin.x - 6;
      h.origin.y = r.origin.y - 6;
      NSRectFill(h);

      // Top left
      h.origin.y += r.size.height + 6;
      NSRectFill(h);

      // Top right
      h.origin.x += r.size.width + 7;
      NSRectFill(h);

      // Bottom right
      h.origin.y -= r.size.height + 6;
      NSRectFill(h);

      // Bottom middle
      mid = r.size.width / 2;
      h.origin.x -= mid + 3;
      NSRectFill(h);

      // Top middle
      h.origin.y += r.size.height + 6;
      NSRectFill(h);

      // Left middle
      mid = r.size.height / 2;
      h.origin.x = r.origin.x - 6;
      h.origin.y = r.origin.y + mid - 3;
      NSRectFill(h);

      // Right middle
      h.origin.x += r.size.width + 7;
      NSRectFill(h);

      o = (NSView *)[e nextObject];
    }
  [self unlockFocus];
}

//
// Determine if point is on a handle
//
- hitTestForHandle:(IMHandleType *)handle atPoint:(NSPoint)p
{
  id e;
  NSView *o;

  // Loop through the selected elements
  // which will have handles attached
  e = [[(IMModelWindow *)window selectedElements] objectEnumerator];
  o = (NSView *)[e nextObject];
  while (o)
    {
      NSRect r = [o frame];
      NSRect h;
      float mid;

      h.size.width = 4;
      h.size.height = 4;

      // Determine if mouse point within a handle

      // Bottom left
      h.origin.x = r.origin.x - 6;
      h.origin.y = r.origin.y - 6;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMBottomLeftHandle;
	  return o;
	}

      // Top left
      h.origin.y += r.size.height + 6;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMTopLeftHandle;
	  return o;
	}

      // Top right
      h.origin.x += r.size.width + 7;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMTopRightHandle;
	  return o;
	}

      // Bottom right
      h.origin.y -= r.size.height + 6;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMBottomRightHandle;
	  return o;
	}

      // Bottom middle
      mid = r.size.width / 2;
      h.origin.x -= mid + 3;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMBottomMiddleHandle;
	  return o;
	}

      // Top middle
      h.origin.y += r.size.height + 6;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMTopMiddleHandle;
	  return o;
	}

      // Left middle
      mid = r.size.height / 2;
      h.origin.x = r.origin.x - 6;
      h.origin.y = r.origin.y + mid - 3;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMLeftMiddleHandle;
	  return o;
	}

      // Right middle
      h.origin.x += r.size.width + 7;
      if ([self mouse: p inRect: h])
	{
	  *handle = IMRightMiddleHandle;
	  return o;
	}

      o = (NSView *)[e nextObject];
    }

  *handle = IMNoHandle;
  return nil;
}

@end
