/*
 * I.c - test the I.h macros.
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: I.c,v 1.1.1.1 1997/11/23 11:45:50 pjm Exp $
 */


#include <stdio.h>

#define I_DEFAULT_HANDLER(e,f,l,p) printf("fail")

#include "../src/I.h"
#include "../src/Q.h"

#include "check.h"

int z = 0;
int o = 1;

#define MAX 5

int v[MAX] = { 0, 1, 2, 3, 4 };

float fv[MAX] = { 1.0, 2.0, 3.0, 4.0, 5.0 };

float fvsum = 1.0+2.0+3.0+4.0+5.0;

float fvprod = 1.0*2.0*3.0*4.0*5.0;

int m[MAX][MAX] = { 
    { 1, 0, 0, 0, 0 },
    { 0, 1, 0, 0, 0 },
    { 0, 0, 1, 0, 0 },
    { 0, 0, 0, 1, 0 },
    { 0, 0, 0, 0, 1 }
};


int main() {
    CHECKMESSAGE("* I.h tests");

    CHECKEMPTY(I(0 == 0));
    CHECKFAIL(I(0 == 1));

    CHECKEMPTY(I(1));
    CHECKFAIL(I(0));
   
    CHECKMESSAGE("** Tests with quantifiers (based on check_Q.c)");
	 
    CHECKEMPTY(I(A(int i = 0, i < MAX, i++, v[i] == i)));
    CHECKFAIL(I(A(int i = 0, i < MAX, i++, v[i] > i)));

    CHECKEMPTY(I(E(int i = 0, i < MAX, i++, v[i] == 4)));
    CHECKEMPTY(I(E(int i = 0, i < MAX, i++, v[i] == 0)));
    CHECKEMPTY(I(E(int i = 0, i < MAX, i++, v[i] == 1)));

    CHECKFAIL(I(E(int i = 0, i < MAX, i++, v[i] == 5)));
    CHECKFAIL(I(E(int i = 0, i < MAX, i++, v[i] == -1)));
    CHECKFAIL(I(E(int i = 0, i < MAX, i++, v[i] > i)));

    CHECKEMPTY(I(C(int i = 0, i < MAX, i++, 1) == MAX));
    CHECKEMPTY(I(C(int i = 0, i < MAX, i++, v[i] == 0) == 1));
    CHECKEMPTY(I(C(int i = 0, i < MAX, i++, v[i] == 4) == 1));
    CHECKEMPTY(I(C(int i = 0, i < MAX, i++, v[i] == 5) == 0));

    CHECKEMPTY(I(E1(int i = 0, i < MAX, i++, v[i] == 4)));
    CHECKEMPTY(I(E1(int i = 0, i < MAX, i++, v[i] == 0)));
    CHECKEMPTY(I(E1(int i = 0, i < MAX, i++, v[i] == 1)));

    CHECKFAIL(I(E1(int i = 0, i < MAX, i++, v[i] > 4)));
    CHECKFAIL(I(E1(int i = 0, i < MAX, i++, v[i] == -1)));
    CHECKFAIL(I(E1(int i = 0, i < MAX, i++, v[i] == i)));

    CHECKFAIL(I(S(int i = 0, i < MAX, i++, v[i]) == 9));
    CHECKEMPTY(I(S(int i = 0, i < 0, i++, v[i]) == 0));

    CHECKEMPTY(I(S(int i = 0, i < MAX, i++, fv[i]) == fvsum));
    CHECKEMPTY(I(S(int i = 0, i < 0, i++, fv[i])==0.0));

    CHECKEMPTY(I(P(int i = 1, i < MAX, i++, v[i])==24));
    CHECKEMPTY(I(P(int i = 1, i < 0, i++, v[i])==1));

    CHECKEMPTY(I(P(int i = 0, i < MAX, i++, fv[i])==fvprod));
    CHECKFAIL(I(P(int i = 0, i < 0, i++, fv[i]) != 1.0));
    

    CHECKMESSAGE("** check out nesting of operations");
    
    CHECKEMPTY(I(A(int i = 0, i < MAX, i++,
		A(int j = 0, j < MAX, j++, 
		  m[i][j] == ((i == j) ? 1 : 0)))));

    CHECKFAIL(I(A(int i = 0, i < MAX, i++,
		A(int j = 0, j < MAX, j++, 
		  m[i][j] == 0))));

    CHECKEMPTY(I(A(int i = 0, i < MAX, i++,
		E(int j = 0, j < MAX, j++, 
		  m[i][j] == 1))));

    CHECKFAIL(I(E(int i = 0, i < MAX, i++,
		E(int j = 0, j < MAX, j++, 
		  m[i][j] == 2))));

    CHECKEMPTY(I(A(int i = 0, i < MAX, i++,
		E1(int j = 0, j < MAX, j++, 
		  m[i][j] == 1))));

    CHECKFAIL(I(A(int i = 0, i < MAX, i++,
		E1(int j = 0, j < MAX, j++, 
		  m[i][j] == 2))));

    CHECKFAIL(I(A(int i = 0, i < MAX, i++,
		E1(int j = 0, j < MAX, j++, 
		  m[i][j] == 0))));

    CHECKFAIL(I(A(int i = 0, i < MAX, i++,
		E1(int j = 0, j < MAX, j++, 
		  m[i][j] == 4))));

    CHECKEMPTY(I(S(int i = 0, i < MAX, i++,
	     S(int j = 0, j < MAX, j++, m[i][j])) == MAX));

    CHECKEMPTY(I(P(int i = 0, i < MAX, i++,
	     S(int j = 0, j < MAX, j++, m[i][j])) == 1));

    CHECKEMPTY(I(C(int i = 0, i < MAX, i++,
	     S(int j = 0, j < MAX, j++, m[i][j]) == 1) == MAX));

    CHECKEMPTY(I(C(int i = 0, i < MAX, i++,
	     S(int j = 0, j < MAX, j++, m[i][j]) == 2) == 0));

    CHECKEMPTY(I(A(int i = 0, i < MAX, i++,
	       C(int j = 0, j < MAX, j++, m[i][j] == 1))));
    
    CHECKMESSAGE("** testing out state saving macros");
    {
      int i;
      ID(int oldi);
      i = 10;
      IS(oldi = i);
      i--;
      CHECKFAIL(I(oldi == i));
      i++;
      CHECKEMPTY(I(oldi == i));
    }

    return 0;
}






