
/* $Id: Pvmfunpack.c,v 1.1 1997/06/27 16:34:44 pvmsrc Exp $ */

#ifdef WIN32
#include "..\..\src\pvmwin.h"
#include <time.h>
#endif 
#include "pvm3.h"
#include "pvm_consts.h"

#ifdef WIN32
void __stdcall
#else
void  __fortran
#endif
PVMFUNPACK (what, vp, cnt, std, info)
   int *what, *cnt, *std, *info;

#ifdef __STDC__
    void *vp;
#else
    char *vp;
#endif
{
   switch( *what ) {

   case BYTE1:
      *info = pvm_upkbyte((char*)vp, *cnt, *std);
      break;
   case INTEGER2:
      *info = pvm_upkshort((short*)vp, *cnt, *std);
      break;
   case INTEGER4:
      *info = pvm_upkint((int*)vp, *cnt, *std);
      break;
   case REAL4:
      *info = pvm_upkfloat((float*)vp, *cnt, *std);
      break;
   case COMPLEX8:
      *info = pvm_upkcplx((float*)vp, *cnt, *std);
      break;
   case REAL8:
      *info = pvm_upkdouble((double*)vp, *cnt, *std);
      break;
   case COMPLEX16:
      *info = pvm_upkdcplx((double*)vp, *cnt, *std);
      break;
   case STRING:
      *info = pvm_upkbyte((char*)vp, *cnt, *std);
      break;
   default:
      *info = PvmBadParam;
      break;
   }
}

