/* Quinn diff, another program to do something or other */
/* Copyright (C) 1997, 1998, James Troup <james@nocrew.org> */

/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <sys/types.h>
#include <db.h>
#include "hash.h"
#include "list.h"

typedef struct _output_info output_info;

struct _output_info {
  char package_name[PACKAGE_STR_LENGTH]; 
  char primary_version[VERSION_STR_LENGTH]; 
  char secondary_version[VERSION_STR_LENGTH]; 
  char priority[PRIORTY_STR_LENGTH]; 
  char section[SECTION_STR_LENGTH]; 
  boolean needs_x; 
  int compare_versions_result;
  boolean multi_binary_source_package;  
  char source_version[PACKAGE_STR_LENGTH];
  int errors;
/*   Qlist *binaries_provided;  FIXME */ 
};

#define SOURCE_VERSION_MISMATCH 0001

#define OUTPUT_MINIMUM 10
#define OUTPUT_NORMAL 20

void output_create (void);
int output_add (const char *package, const char *primary_version, 
		const char *secondary_version, const char *priority, 
		const char *section, const int needs_x,
		const int compare_versions_result, const boolean multi_binary_source_package, 
		const char *source_version);
void output_mbs_update (const char *priority, const int needs_x, 
			output_info *source_package, const char *source_version);
output_info *output_retrieve (const char *package);
void output_display(void);
void output_destroy(void);
