/* vi:set ts=8 sts=0 sw=8:
 * $Id: msgbar.c,v 1.8 1998/10/09 15:29:37 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdarg.h>
#include <string.h>
#include "win.h"
#include "msgbar.h"
#include "prefs.h"


/*** global function definitions ***/
/*
 * PUBLIC: msgbar_clear
 *
 * clears the text by using a space (" ").  apparently, Gtk has no provision
 * for clearing a label widget.
 */
void
msgbar_clear(gpointer data)
{
	win_t *w = (win_t *)data;

	msgbar_printf(w, " ");
	gtk_timeout_remove(w->timeout_id);
} /* msgbar_clear */


/*
 * PUBLIC: msgbar_init
 *
 * initialize the message bar.  called from win_new().
 */
void
msgbar_init(win_t *w, GtkWidget *parent)
{
	w->msgbar = gtk_label_new("Hello world");
	gtk_box_pack_start(GTK_BOX(parent), w->msgbar, FALSE, FALSE, 0);
	gtk_misc_set_alignment(GTK_MISC(w->msgbar), 0.0, 0.5);

	/* set according to preferences */
	if (IS_SHOW_MSGBAR())
		gtk_widget_show(w->msgbar);
} /* msgbar_init */


/*
 * PUBLIC: msgbar_printf
 *
 * sets the message/status bar.  remembers the last message set so that a
 * duplicate one won't be set on top of the current one.
 */
void
msgbar_printf(win_t *w, const char *fmt, ...)
{
#ifdef GTK_HAVE_FEATURES_1_1_0
	va_list args;
#else
	va_list ap1, ap2;
#endif
	char *msg;

#ifdef GTK_HAVE_FEATURES_1_1_0
	va_start(args, fmt);
	msg = g_strdup_vprintf(fmt, args);
	va_end(args);
#else
	va_start(ap1, fmt);
	va_start(ap2, fmt);
	msg = g_vsprintf(fmt, &ap1, &ap2);
	va_end(ap1);
	va_end(ap2);
#endif
	if (w->lastmsg == NULL || strcmp(w->lastmsg, msg)) {
		gtk_label_set(GTK_LABEL(w->msgbar), msg);
		if (w->lastmsg)
			g_free(w->lastmsg);
		w->lastmsg = g_strdup(msg);
		gtk_timeout_remove(w->timeout_id);
		msgbar_timeout_add(w);
	}
#ifdef GTK_HAVE_FEATURES_1_1_0
	g_free(msg);
#endif
} /* msgbar_printf */


/*
 * PUBLIC: msgbar_redraw
 *
 * redraws the msgbar for a specified window
 */
void
msgbar_redraw(win_t *w)
{
	if (IS_SHOW_MSGBAR()) {
		gtk_widget_show(w->msgbar);
		gtk_widget_show(w->docinfo);
	} else {
		gtk_widget_hide(w->msgbar);
		gtk_widget_hide(w->docinfo);
	}
} /* msgbar_redraw */


/*
 * PUBLIC: msgbar toggle
 *
 * toggles the msgbar on/off
 */
void
msgbar_toggle(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	g_assert(w != NULL);
	if (IS_SHOW_MSGBAR()) {
		gtk_widget_hide_all(w->hbox_bot);
		CLEAR_SHOW_MSGBAR();
	} else {
		gtk_widget_show_all(w->hbox_bot);
		SET_SHOW_MSGBAR();
	}
} /* msgbar_toggle */


/*
 * PUBLIC: msgbar_timeout_add
 *
 * after ~3 seconds, clears the message bar.
 */
void
msgbar_timeout_add(win_t *w)
{
	w->timeout_id = gtk_timeout_add(3000, (GtkFunction)msgbar_clear, w);
} /* msgbar_timeout_add */


/* the end */
