/* vi:set ts=8 sts=0 sw=8:
 * $Id: prjbar.c,v 1.6 1998/10/08 19:14:08 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdarg.h>
#include <string.h>
#include "win.h"
#include "project.h"
#include "prjbar.h"
#include "prefs.h"

#ifdef WANT_PROJECT

#define NO_PROJECT	"Project: NONE / Files: NONE"


/*** global function definitions ***/
/*
 * PUBLIC: prjbar_clear
 *
 * clears the text by using a space (" ").  apparently, Gtk has no provision
 * for clearing a label widget.
 */
void
prjbar_clear(gpointer data)
{
	win_t *w = (win_t *)data;

	prjbar_update(w);
} /* prjbar_clear */


/*
 * PUBLIC: prjbar_init
 *
 * initialize the message bar.  called from win_new().
 */
void
prjbar_init(win_t *w)
{
	GtkWidget *tmp;

	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(w->mainbox), tmp, FALSE, TRUE, 0);
	gtk_widget_show(tmp);
	w->prjbar = gtk_label_new(NO_PROJECT);
	gtk_box_pack_start(GTK_BOX(w->mainbox), w->prjbar, FALSE, TRUE, 0);
	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(w->mainbox), tmp, FALSE, TRUE, 0);
	gtk_widget_show(tmp);

	/* set according to preferences */
	if (IS_SHOW_PRJBAR())
		gtk_widget_show(w->prjbar);
} /* prjbar_init */


/*
 * PUBLIC: prjbar_update
 *
 * sets the project status bar.
 */
void
prjbar_update(win_t *w)
{
	char *msg;
	prj_t *prj = (prj_t *)(w->prj);

	if (prj) {
		msg = (char *)g_malloc(strlen(prj->name) + 128);
		g_snprintf(msg, strlen(prj->name) + 128,
				"Project: %s / Files: %d",
				prj->name, prj->numfiles);
		gtk_label_set(GTK_LABEL(w->prjbar), msg);
		g_free(msg);
	} else
		gtk_label_set(GTK_LABEL(w->prjbar), NO_PROJECT);
} /* prjbar_update */


/*
 * PUBLIC: prjbar_redraw
 *
 * redraws the prjbar for a specified window
 */
void
prjbar_redraw(win_t *w)
{
	if (IS_SHOW_PRJBAR())
		gtk_widget_show(w->prjbar);
	else
		gtk_widget_hide(w->prjbar);
} /* prjbar_toggle */


/*
 * PUBLIC: prjbar toggle
 *
 * toggles the prjbar on/off
 */
void
prjbar_toggle(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	g_assert(w != NULL);
	if (IS_SHOW_PRJBAR()) {
		gtk_widget_hide(w->prjbar);
		CLEAR_SHOW_PRJBAR();
	} else {
		gtk_widget_show(w->prjbar);
		SET_SHOW_PRJBAR();
	}
} /* prjbar_toggle */


#endif	/* WANT_PROJECT */
/* the end */
