"""Module that interacts with Python/Tk."""

#    Copyright (C) 1998 Kevin O'Connor
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from Tkinter import *
import select
import string
import types
import re

from Tk_Pane import *
import Tk_VDB
import MapWin
import CenWin
import LoginWin

import OutWin
import TeleWin

import empDb
import empQueue

# - Ack, dont need these after all..
## # List of known Tk events - I hope this is portable.
## WE_PRESS = '4'
## WE_RELEASE = '5'
## WE_MOTION = '6'
## WE_ENTER = '7'
## WE_LEAVE = '8'

###########################################################################
#############################  Main window    #############################
class mainWin:
    """Tk interface"""

    def __init__(self):
	global viewer
	MapWin.viewer = CenWin.viewer = LoginWin.viewer = TeleWin.viewer = viewer = self

	self.hisList = [""]
	self.hisPos = 0
	self.stsList = []
	self.updateList = []
	self.atPrompt = 0

##	self.root = Tk()
	self.Root = Display
##	self.Root.minsize(1, 1)		     # Set minimum size
	self.Root.title("Python/Tk Empire Interface")

	self.coord = StringVar()
	self.queueStatus = StringVar()
	self.queueStatus.set("Starting")

	self.updateStatus = StringVar()
	self.updateStatus.set("")

	statusbar = Frame(self.Root, name='statusbar')
	statusbar.pack(side=BOTTOM, fill=X)
	Label(self.Root, name='coord', textvariable=self.coord, width=20
	      ).pack(in_=statusbar, side=RIGHT)
	Label(self.Root, name='socket', textvariable=self.queueStatus,
	      width=20).pack(in_=statusbar, side=RIGHT)
	Label(self.Root, name='countdown', textvariable=self.updateStatus,
	      width=10).pack(in_=statusbar, side=RIGHT)

	self.Status = Entry(self.Root, name='status', relief=FLAT)
	self.Status.pack(in_=statusbar, anchor=S, fill=X)
	self.Status.bind('<Key-Return>', self.DoStatus)
	self.Status.insert(0, "Welcome to empire!")
	self.Status['state']=DISABLED

	infoframe = Frame(self.Root, name='infoframe')
	infoframe.pack(side=LEFT, fill=BOTH)
	self.CmdPrompt = Label(self.Root, name='cmdprompt', anchor=NE)
	self.CmdPrompt.pack(in_=infoframe, side=BOTTOM, anchor=S, fill=X)
	self.CmdPrompt.bind('<Configure>',
			    (lambda e, cp=self.CmdPrompt:
			     cp.configure({'wraplength': e.width})))
	self.cen = CenWin.cenWin(infoframe)

	mapframe = Frame(self.Root, name='mapframe', class_='Map')
	ioframe = Frame(self.Root, name='ioframe', class_='Censor')

	self.map = MapWin.mapSubWin(mapframe)

	self.Prompt = Entry(self.Root, name='prompt')
	self.Prompt.pack(in_=ioframe, side=BOTTOM, anchor=S, fill=X)
	self.Prompt.bind('<Key-Return>', self.DoCmd)
	self.Prompt.bind('<Control-z>', self.DoCtld)
	self.Prompt.bind('<Up>', self.DoPrev)
	self.Prompt.bind('<Down>', self.DoNext)
	self.Prompt.focus()

	scrollY = Scrollbar(self.Root, name='ioscrollbar')
	scrollY.pack(in_=ioframe, side=RIGHT, anchor=E, fill=Y)
	self.Output = Text(self.Root, name='iobox', state=DISABLED,
			   yscrollcommand=scrollY.set)
	self.Output.pack(in_=ioframe, side=LEFT, anchor=SE, expand=1, fill=BOTH)
	scrollY['command'] = self.Output.yview
	self.Output.bind('<Button-2>',
			 (lambda e, s=self.Output:
			  s.focus_get().insert(INSERT, s.selection_get())))
	self.Output.bind('<Button-3>', self.DoLocateSector)

	paned(self.Root, mapframe, ioframe)

	self.Root.bind('<Prior>',
		       (lambda e, s=self.Output:
			s.yview('scroll', -1, 'page')))
	self.Root.bind('<Next>',
		       (lambda e, s=self.Output:
			s.yview('scroll', 1, 'page')))

	# Establish default bindings for text prompts
	vals = Tk_VDB.getOptions(
	    self.Output,
	    ['background', 'bgstipple', 'borderwidth',
	     'fgstipple', 'font', 'foreground', 'justify',
	     'lmargin1', 'lmargin2', 'offset', 'overstrike',
	     'relief', 'rmargin', 'spacing1', 'spacing2',
	     'spacing3', 'tabs', 'underline', 'wrap'],
	    ['data', 'prompt', 'command', 'flush',
	     'subcommand', 'flash'])
	for i, j in vals.items():
	    apply(self.Output.tag_configure, (i,), j)
##	self.lwrite(('data', 'data'), '\n', ('prompt :', 'prompt'),
##		    ('command', 'command'), '\n',
##		    ('subprompt :', 'subprompt'),
##		    ('subcommand', 'subcommand'), '\n', ('flash', 'flash'))

	self.markSectors = self.map.markSectors
	self.loginCallback = LoginWin.loginWin()
	self.telegramWindow = TeleWin.teleWin()
	self.Root.update_idletasks()
	self.Root.pack_propagate(0)
	infoframe.pack_propagate(0)
	self.cen.SetSect((0,0,0,0))

    def lwrite(self, *args):
	"""Low level write.  Add MSG to text output window."""
	self.Output['state']=NORMAL
	for i in args:
	    if type(i) != types.TupleType:
		msg = i
		tag = ''
	    else:
		msg, tag = i
	    self.Output.insert(END, msg, tag)

	# Delete any lines in excess of 1000
	self.Output.delete('1.0', 'end - 1000 lines')

	self.Output['state']=DISABLED
	self.Output.see(END)

    def setprompt(self, prompt=None):
	"""Set the prompt window to the standard empire prompt."""
	if self.stsList:
	    # Dont update the prompt if the status window is in use.
	    return
	if prompt == None:
	    prompt = empDb.GetPrompt()
	self.CmdPrompt['text'] = prompt

    def Begin(self, cmd):
	"""empQueue handler: called at the beginning of each command."""
	if not self.atPrompt:
	    self.lwrite('\n',
			(empDb.GetPrompt(), 'prompt'),
			(cmd, 'command'))
	else:
	    self.lwrite((cmd, 'command'))
	    self.atPrompt = 0

    def data(self, msg):
	"""empQueue handler: called with each line of data that is received."""
	self.lwrite('\n', (msg, 'data'))
	self.atPrompt = 0

    def flush(self, msg):
	"""empQueue handler: called when a subprompt is encountered."""
	def hdl(cmd, self=self):
	    self.lwrite((cmd, 'subcommand'))
	    self.atPrompt = 0
	    self.ioq.SendNow(cmd)
	self.lwrite('\n', (msg, 'flush'))
	self.bufferStatus(msg, hdl)
	self.atPrompt = 0

    def Answer(self, msg):
	"""empQueue handler: called when a subprompt is answered."""
	self.lwrite('\n', (msg, 'subcommand'))
	self.atPrompt = 0

    def End(self, cmd):
	"""empQueue handler: called at the end of each command."""
	p = empDb.GetPrompt()
	self.lwrite('\n', (p, 'prompt'))
	self.setprompt(p)
	self.atPrompt = 1

    def flash(self, msg):
	"""empQueue handler: called when an async line of data is received."""
	self.lwrite('\n', (msg, 'flash'))
	self.atPrompt = 0

    def inform(self):
	"""empQueue handler: called when there is an async prompt update."""
	p = empDb.GetPrompt()
	self.setprompt(p)
	if self.atPrompt:
	    self.lwrite('\n', (p, 'prompt'))

    def updateDB(self, total=0):
	"""DB handler: called everytime an update to the database is made."""
	for i in self.updateList:
	    i.redraw(total)
	for i, j in empDb.megaDB['updated'].items():
	    if type(j) == types.ListType:
		del j[:]
	    else:
		j.clear()

    def queryCommand(self, msg, cmd, post=None, pre=None):
	if self.stsList:
	    # Dont buffer additional commands.
	    self.Root.bell()
	    return
	if pre:
	    self.ioq.Send(pre)
	def f(msg, self=self, cmd=cmd, post=post):
	    """Function to be called when status window finishes."""
	    if not msg:
		return
	    self.ioq.Send(cmd % (msg,))
	    if post:
		self.ioq.Send(post)
	self.bufferStatus(msg, f)

    def bufferStatus(self, prompt, hdl):
	self.stsList.append((prompt, hdl))
	if len(self.stsList) == 1:
	    self.CmdPrompt['anchor'] = NW
	    self.CmdPrompt['text'] = self.stsList[0][0]
	    self.Status['state'] = NORMAL
	    self.Status['relief'] = SUNKEN
	    self.Status.delete(0, END)
	    self.Status.focus()

    def DoStatus(self, event):
	cmd = self.Status.get()
	self.Status.delete(0, END)
	hdl = self.stsList[0][1]
	del self.stsList[0]
	hdl(cmd)
	if self.stsList:
	    self.CmdPrompt['text'] = self.stsList[0][0]
	else:
	    self.Status['state'] = DISABLED
	    self.Status['relief'] = FLAT
	    self.CmdPrompt['anchor'] = NE
	    self.CmdPrompt['text'] = ""
	    self.Prompt.focus()

    def DoCmd(self, event):
	cmd = self.Prompt.get()
	self.Prompt.delete(0, END)

	# Add command to history list
	del self.hisList[0]
	try: self.hisList.remove(cmd)
	except ValueError: pass
	self.hisList[:0] = ["", cmd]
	self.hisPos = 0
	del self.hisList[100:]

	self.ioq.Send(cmd)

    def DoPrev(self, event):
	if self.hisPos >= len(self.hisList)-1:
	    self.Root.bell()
	    return
	if self.hisPos == 0:
	    self.hisList[0] = self.Prompt.get()
	self.Prompt.delete(0, END)
	self.hisPos = self.hisPos + 1
	self.Prompt.insert(0, self.hisList[self.hisPos])

    def DoNext(self, event):
	if self.hisPos <= 0:
	    self.Root.bell()
	    return
	self.Prompt.delete(0, END)
	self.hisPos = self.hisPos - 1
	self.Prompt.insert(0, self.hisList[self.hisPos])

    def DoCtld(self, event):
	self.ioq.Send("ctld")

    def checkQueue(self):
	self.queueStatus.set(self.ioq.sock.GetStatusMsg())
	tkinter.createtimerhandler(500, self.checkQueue)
	hours, minutes, seconds = empDb.megaDB['time'].getCountDown()
	if hours > 0 or minutes > 5:
	    seconds = 0
	self.updateStatus.set("%d:%02d:%02d" % (hours, minutes, seconds))

    def HandleSock(self, file=None, mask=None):
	self.ioq.HandleInput()

    def startConn(self):
	tkinter.createfilehandler(self.ioq, tkinter.READABLE, self.HandleSock)
	self.ioq.Send("exec connect.emp")

    def stopConn(self):
	tkinter.deletefilehandler(self.ioq)

    def main(self):
	self.checkQueue()
	self.Root.mainloop()
##	while 1:
##	    pending = select.select([self.ioq], [], [], .1)[0]
##	    self.root.update()
##	    if pending:
##		self.HandleSock()

    def CmdWRead(self):
	"""Open telegram window."""
	return self.telegramWindow.mapWindow()

    def CmdWind(self, out, name, width=None):
	"""Open an output box."""
	return OutWin.SimpDisp(out, name, width)

    def CmdMap(self):
	"""Open an additional map window."""
	root = Toplevel(class_='Map')
	root.title("Empire map")
	root.iconname("Empire map")
	map = MapWin.mapSubWin(root)
	def f(self=self, root=root, map=map):
	    self.updateList.remove(map)
	    root.destroy()
	root.protocol('WM_DELETE_WINDOW', f)

    sectorFormat = re.compile("^"+empDb.s_sector+"$")
    def DoLocateSector(self, event):
	pos = "@%s,%s" % (event.x, event.y)
	start = self.Output.search("^|[^-0-9,]", pos+" + 1 chars",
				   regexp=1, backwards=1)
	end = self.Output.search("[^-0-9,]|$", pos, regexp=1)
	mm = self.sectorFormat.match(
	    string.strip(self.Output.get(start, end)))
	if mm:
	    x, y = map(string.atoi, mm.groups())
	    self.cen.SetSect((x, x, y, y))
	else:
	    self.Root.bell()

###########################################################################
#############################  Startup	      #############################
try:
    Display = Tk(None, None, "Ptkei")
except TclError, e:
    print "Unable to open the root window."
    print "Received error:" + str(e)
    raise ImportError

# Read in options database
Display.option_readfile('TkOption', 'startupFile')

# Handle platforms that dont support the Tcl file handler
def bogusFileHandler(fileno, mask, hdlr):
    def hdl(fileno=fileno, mask=mask, hdlr=hdlr):
	hdlr(fileno, mask)
	bogusFileHandler(fileno, mask, hdlr)
    bogusFileTimer = tkinter.createtimerhandler(100, hdl)

def bogusDelFileHandler(fileno):
    bogusFileTimer.deletetimerhandler()

if tkinter.createfilehandler == None:
    tkinter.createfilehandler = bogusFileHandler
    tkinter.deletefilehandler = bogusDelFileHandler
