/* Risk! for Linux..
 * intro_screen.c
 *
 * Displays the title screen with a moving status widget
 * until there's input to stdin.  Indicates program is loading!
 *
 * Copyright (C) 1998 Joel Nordell
 *
 * This file is protected under the GPL license.
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include "title.xpm"

// For the progress bar on the init window
static int ptimer = 0;
int pstat = FALSE;

int done_with_board = FALSE;

GtkWidget *TitleXpm = NULL;
GdkPixmap *TitlePixmap = NULL;

GtkWidget *TitleWindow = NULL;
GtkWidget *MainWindow = NULL;

gint progress(gpointer data) {
  gfloat pvalue;

  pvalue = GTK_PROGRESS_BAR(data)->percentage;
  if ((pvalue >= 1.0) || (pstat == FALSE)) {
    pvalue = 0.0;
    pstat = TRUE;
  }
  pvalue += 0.02;

  gtk_progress_bar_update(GTK_PROGRESS_BAR(data), pvalue);

  return TRUE;
}

GtkWidget *title_window() {
  GtkWidget *window;
  GtkWidget *status;
  GtkWidget *fixed;

  window = gtk_window_new(GTK_WINDOW_POPUP);
  gtk_window_set_title(GTK_WINDOW(window), "Global Conquest loading...");

  fixed = gtk_fixed_new();
  gtk_widget_show(fixed);

  status = gtk_progress_bar_new();
  gtk_widget_set_usize(status, 250, 0);
  gtk_widget_show(status);

//  gtk_widget_show(window);
//  gtk_widget_hide(window);
  gtk_widget_realize(window);

  TitlePixmap = gdk_pixmap_create_from_xpm_d (window->window, NULL, NULL,
					 (gchar **)title_xpm);
  TitleXpm = gtk_pixmap_new(TitlePixmap, NULL);
  gtk_container_add(GTK_CONTAINER(window), fixed);
  gtk_fixed_put(GTK_FIXED(fixed), TitleXpm, 0, 0);
  gtk_fixed_put(GTK_FIXED(fixed), status, 35, 155);
  gtk_widget_show(TitleXpm);
  gtk_window_position(GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_show(window);

  TitleWindow = window;
  ptimer = gtk_timeout_add(50, progress, status);
  return status;
}

void got_input(gpointer data, gint source, GdkInputCondition condition) {
  gtk_exit(0);
}

main(int argc, char **argv) {
  char gtkrc[100];

  if (getenv("HOME") != NULL) {
    sprintf(gtkrc, "%s/.gtkrc", getenv("HOME"));
  } else sprintf(gtkrc, "/etc/system.gtkrc");

  gtk_init (&argc, &argv);
  gtk_rc_parse (gtkrc);
  title_window();
  gdk_input_add(STDIN_FILENO, GDK_INPUT_READ, got_input, NULL);
  gtk_main();
}
