
/*-
# MOTIF-BASED ABACUS
#
#  xmabacus.c
#
###
#
#  Copyright (c) 1993 - 96	David Albert Bagley, bagleyd@bigfoot.com
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/*-
  Version 5: 95/09/30 Xt/Motif
  Version 4: 94/05/07 Xt
  Version 3: 93/02/03 Motif
  Version 2: 91/12/17 XView
  Version 1: 91/02/14 SunView
*/

#include <stdlib.h>
#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/cursorfont.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include "Abacus.h"
#include "abacus.xbm"
#include "mouse-l.xbm"
#include "mouse-r.xbm"

static void CallbackAbacus(Widget w, caddr_t clientData, abacusCallbackStruct * callData);
static void motif_print(Widget w, char *text);

static Widget tracker;

static void
Usage(void)
{
	(void) fprintf(stderr, "usage: xmabacus\n");
	(void) fprintf(stderr,
	     "\t[-geometry [{width}][x{height}][{+-}{xoff}[{+-}{yoff}]]]\n");
	(void) fprintf(stderr,
		"\t[-display [{host}]:[{vs}]][-fg {color}] [-bg {color}]\n");
	(void) fprintf(stderr,
		 "\t[-bead {color}] [-{border|bd} {color}] [-bars {int}]\n");
	(void) fprintf(stderr,
		       "\t[-spaces {int}] [-tnumber {int}] [-bnumber {int}] [-tfactor {int}]\n");
	(void) fprintf(stderr,
		   "\t[-tnumber {int}] [-bnumber {int}] [-tfactor {int}]\n");
	(void) fprintf(stderr,
	"\t[-bfactor {int}] [-[no]torient] [-[no]borient] [-delay msecs]\n");
	exit(1);
}

static XrmOptionDescRec options[] =
{
	{"-fg", "*abacus.Foreground", XrmoptionSepArg, NULL},
	{"-bg", "*Background", XrmoptionSepArg, NULL},
	{"-foreground", "*abacus.Foreground", XrmoptionSepArg, NULL},
	{"-background", "*Background", XrmoptionSepArg, NULL},
	{"-bead", "*abacus.beadColor", XrmoptionSepArg, NULL},
	{"-border", "*abacus.beadBorder", XrmoptionSepArg, NULL},
	{"-bd", "*abacus.beadBorder", XrmoptionSepArg, NULL},
	{"-bars", "*abacus.bars", XrmoptionSepArg, NULL},
	{"-spaces", "*abacus.spaces", XrmoptionSepArg, NULL},
	{"-tnumber", "*abacus.topNumber", XrmoptionSepArg, NULL},
	{"-bnumber", "*abacus.bottomNumber", XrmoptionSepArg, NULL},
	{"-tfactor", "*abacus.topFactor", XrmoptionSepArg, NULL},
	{"-bfactor", "*abacus.bottomFactor", XrmoptionSepArg, NULL},
	{"-torient", "*abacus.topOrient", XrmoptionNoArg, "TRUE"},
	{"-notorient", "*abacus.topOrient", XrmoptionNoArg, "FALSE"},
	{"-borient", "*abacus.bottomOrient", XrmoptionNoArg, "TRUE"},
	{"-noborient", "*abacus.bottomOrient", XrmoptionNoArg, "FALSE"},
	{"-delay", "*abacus.delay", XrmoptionSepArg, NULL}
};

int
main(int argc, char **argv)
{
	Widget      toplevel, abacus;
	Widget      panel, panel2, rowcol;
	Pixmap      mouseLeftCursor, mouseRightCursor;
	Pixel       fg, bg;
	Arg         arg[2];

	toplevel = XtInitialize(argv[0], "Abacus", options, XtNumber(options),
				&argc, argv);
	if (argc != 1)
		Usage();
	XtSetArg(arg[0], XtNiconPixmap,
		 XCreateBitmapFromData(XtDisplay(toplevel),
				       RootWindowOfScreen(XtScreen(toplevel)),
			 (char *) abacus_bits, abacus_width, abacus_height));
	XtSetArg(arg[1], XmNkeyboardFocusPolicy, XmPOINTER);	/* not XmEXPLICIT */
	XtSetValues(toplevel, arg, 2);
	panel = XtCreateManagedWidget("panel", xmPanedWindowWidgetClass, toplevel,
				      NULL, 0);
	panel2 = XtVaCreateManagedWidget("panel2", xmPanedWindowWidgetClass, panel,
					 XmNseparatorOn, False,
					 XmNsashWidth, 1,
					 XmNsashHeight, 1,
					 NULL);

	rowcol = XtVaCreateManagedWidget("Rowcol", xmRowColumnWidgetClass, panel2,
			  XmNnumColumns, 4, XmNpacking, XmPACK_COLUMN, NULL);
	XtVaGetValues(rowcol, XmNforeground, &fg, XmNbackground, &bg, NULL);
	mouseLeftCursor = XCreatePixmapFromBitmapData(XtDisplay(rowcol),
	      RootWindowOfScreen(XtScreen(rowcol)), (char *) mouse_left_bits,
				 mouse_left_width, mouse_left_height, fg, bg,
				     DefaultDepthOfScreen(XtScreen(rowcol)));
	mouseRightCursor = XCreatePixmapFromBitmapData(XtDisplay(rowcol),
	     RootWindowOfScreen(XtScreen(rowcol)), (char *) mouse_right_bits,
			       mouse_right_width, mouse_right_height, fg, bg,
				     DefaultDepthOfScreen(XtScreen(rowcol)));
	XtVaCreateManagedWidget("mouseLeftText", xmLabelGadgetClass, rowcol,
	     XtVaTypedArg, XmNlabelString, XmRString, "Move bead", 10, NULL);
	XtVaCreateManagedWidget("mouseLeft", xmLabelGadgetClass, rowcol,
	      XmNlabelType, XmPIXMAP, XmNlabelPixmap, mouseLeftCursor, NULL);
	XtVaCreateManagedWidget("mouseRightText", xmLabelGadgetClass, rowcol,
	     XtVaTypedArg, XmNlabelString, XmRString, "    Clear", 10, NULL);
	XtVaCreateManagedWidget("mouseRight", xmLabelGadgetClass, rowcol,
	     XmNlabelType, XmPIXMAP, XmNlabelPixmap, mouseRightCursor, NULL);

	tracker = XtCreateManagedWidget("0", xmLabelWidgetClass, panel2, NULL, 0);

	abacus = XtCreateManagedWidget("abacus", abacusWidgetClass, panel, NULL, 0);
	XtAddCallback(abacus, XtNselectCallback, (XtCallbackProc) CallbackAbacus,
		      (XtPointer) NULL);

	XtRealizeWidget(toplevel);
	XGrabButton(XtDisplay(abacus), AnyButton, AnyModifier, XtWindow(abacus),
		TRUE, ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		    GrabModeAsync, GrabModeAsync, XtWindow(abacus),
		    XCreateFontCursor(XtDisplay(abacus), XC_crosshair));
	XtMainLoop();

#ifdef VMS
	return 1;
#else
	return 0;
#endif
}

static void
CallbackAbacus(Widget w, caddr_t clientData, abacusCallbackStruct * callData)
{
	motif_print(tracker, callData->buffer);
}

static void
motif_print(Widget w, char *text)
{
	Arg         wargs[1];
	XmString    xmstr;

	if (!XtIsSubclass(w, xmLabelWidgetClass))
		XtError("motif_printf() requires a Label Widget");
	xmstr = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
	XtSetArg(wargs[0], XmNlabelString, xmstr);
	XtSetValues(w, wargs, 1);
}
