#include "xev.h"
#include "enemy.h"

PRIVATE Pixmap pixmap,pixmap_core[3];
PRIVATE Pixmap pixmap_mask,pixmap_core_mask[3];
PRIVATE GC gc,gc_core[3];
PRIVATE int c_xy[5][2] = {
      {4*CSIZE,4*CSIZE},
      {2*CSIZE+13,2*CSIZE+14},
      {6*CSIZE-11,2*CSIZE+14},
      {2*CSIZE+13,6*CSIZE-10},
      {6*CSIZE-11,6*CSIZE-10}
};

PRIVATE int core_char[5] = {0,1,2,2,1};
PRIVATE int ando_no,core_enemy[5];
PRIVATE int shot_p[5][3] = {
      {10,15,20},
      {15,20,25},
      {20,25,30},
      {28,30,34},
      {30,35,39}
};


void AndoSetChar()
{
      int c_nox,c_noy,c_no;
      char fn[256],img[CSIZE*CSIZE] , mask[10368],maskc[256];
      char *c_fn[] = {
	    "acore.img",
	    "acore21.img",
	    "acore22.img"
      };
      int x,y;
      XGCValues gcv;
      
      gcv.graphics_exposures = False;
      pixmap = XCreatePixmap(d,w,9*CSIZE,9*CSIZE,depth);
      bzero(mask , sizeof(mask));
      gc = XCreateGC(d,w,GCGraphicsExposures,&gcv);

      for(c_noy = 0 ; c_noy < 9 ; c_noy++) {
	    for(c_nox = 0 ; c_nox < 9 ; c_nox++) {
		  sprintf(fn,"%s/a%d%d.img",IMAGE_DIR,c_noy+1,c_nox+1);
		  LoadChar(fn,img,sizeof(img));
		  
		  for(y = 0 ; y < CSIZE ; y++)
		    for(x = 0 ; x < CSIZE ; x++) {
			  if(img[y*CSIZE+x] != 100) {
				mask[c_noy*36*32+y*36+c_nox*4+x/8] 
				  |= (1<< (x%8));
				XSetForeground(d,gc,
					       pixel[img[y*CSIZE+x]]);
				XDrawPoint(d,pixmap,gc,
					   c_nox*CSIZE+x,c_noy*CSIZE+y);
			  }
		    }

	    }
      }
      pixmap_mask 
	= XCreateBitmapFromData(d,w,mask,9*CSIZE,9*CSIZE);
      XSetClipMask(d,gc,pixmap_mask);

      for(c_no = 0 ; c_no < 3 ; c_no++) {
            int x,y;
            
	    sprintf(tpath , "%s/%s",IMAGE_DIR,c_fn[c_no]);
            LoadChar(tpath,img , sizeof(img));

            pixmap_core[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            gcv.graphics_exposures = False;
	    gc_core[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

            bzero(maskc , sizeof(maskc));
	    for(y = 0 ; y < CSIZE ; y++)
              for(x = 0 ; x < CSIZE ; x++) {
                    if(img[y*CSIZE+x] != 100) {
                          maskc[y*4+x/8] |= (1<< (x%8));
                          XSetForeground(d,gc_core[c_no],
                                         pixel[img[y*CSIZE+x]]);
                          XDrawPoint(d,pixmap_core[c_no],gc_core[c_no],x,y);
                    }
              }
            pixmap_core_mask[c_no] 
              = XCreateBitmapFromData(d,w,maskc,CSIZE,CSIZE);
            XSetClipMask(d,gc_core[c_no],pixmap_core_mask[c_no]);
      }


      
}

void AndoFree()
{
      int i;

      for(i = 0 ;  i < 3 ; i++) {
	    XFreePixmap(d,pixmap_core[i]);
	    XFreePixmap(d,pixmap_core_mask[i]);
	    XFreeGC(d,gc_core[i]);
      }
      
      XFreePixmap(d,pixmap);
      XFreePixmap(d,pixmap_mask);
      XFreeGC(d,gc);
}

void InitCore(enemy_no,core)
     int enemy_no ,  core;
{
      enemy[enemy_no].tmp3 = core;
      enemy[enemy_no].enemy_no = CORE;
}
      
void AndoInit(enemy_no)
     int enemy_no;
{
      int i,core;

      andoa_flag = 1;
      ando_no = enemy_no;

      enemy[enemy_no].enemy_no = ANDOA;
      enemy[enemy_no].tmp1 = 18*9;
      enemy[enemy_no].tmp2 = 690;
      enemy[enemy_no].tmp3 = 0;
      enemy[enemy_no].x.dummy = 3*CSIZE*65536;
      enemy[enemy_no].y.dummy = -65536*CSIZE*9;
      enemy[enemy_no].vx = 0;
      
      for(core = 0 ; core < 5 ; core++) {
	    for(i = ando_no ; i < ENEMY_MAX ; i++) {
		  if(!enemy[i].enemy_no){
			InitCore(i,core);
			core_enemy[core] = i;
			break;
		  }
	    }
      }
}

int Core(enemy_no)
     int enemy_no;
{
      int sx,sy , core_no;

      if(enemy[ando_no].tmp1 < 1) {
	    core_no = enemy[enemy_no].tmp3;
	    sx = c_xy[core_no][0]+enemy[ando_no].x.sht[UNION];
	    sy = c_xy[core_no][1]+enemy[ando_no].y.sht[UNION];
	    
	    SetSprite(sx,sy,pixmap_core[core_char[core_no]],
		      gc_core[core_char[core_no]],
		      CSIZE,CSIZE);
	    
	    if((jx.sht[UNION] - sx) > -20 &&
	       (jx.sht[UNION] - sx) < 20 &&
	       (jy.sht[UNION] - sy) > 198 &&
	       (jy.sht[UNION] - sy) < 224)
	      shojun_flag = 1;
	    
	    if(core_no != 0 && (rand() & 255) < shot_p[game_level][level])
	      EShut(enemy_no , sx*65536,sy*65536);

	    if((shot_chi.x.sht[UNION] - sx) > -10 &&
	       (shot_chi.x.sht[UNION] - sx) < 32 &&
	       (shot_chi.y.sht[UNION] - sy) > -10 &&
	       (shot_chi.y.sht[UNION] - sy) < 42 &&
	       shot_chi.z == 1) {
		  if(core_no == 0) {
			int i;
			score += 2000;
			andoa_flag = 0;
			enemy[ando_no].tmp1 = 10000;
			for(i = 0 ; i < 5 ;i++) {
			      enemy[core_enemy[i]].x.sht[UNION] 
				= c_xy[enemy[core_enemy[i]].tmp3][0]+
				  enemy[ando_no].x.sht[UNION];
			      enemy[core_enemy[i]].y.sht[UNION] 
				= c_xy[enemy[core_enemy[i]].tmp3][1]+
				  enemy[ando_no].y.sht[UNION];
			      BragInit(0);
			      BombInit(core_enemy[i]);
			}
			
		  }else {
			score += 1000;
			enemy[enemy_no].x.sht[UNION] = sx,
			enemy[enemy_no].y.sht[UNION] = sy;
			BombInit(enemy_no);
		  }
		  score += 150;
		  return 0;
	    } else {
		  return 0;
	    }
      }
      return 0;
}

int Ando(enemy_no)
     int enemy_no;
{
      int i;
      short sx,sy;


      enemy[enemy_no].y.dummy += 65536*2*(enemy[enemy_no].tmp1 > 0)
	 - 65536*2*(enemy[enemy_no].tmp3 == 1);
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      enemy[enemy_no].tmp1 -= (enemy[enemy_no].tmp1 > 0);
      enemy[enemy_no].tmp2 -= (enemy[enemy_no].tmp2 > -1);


       if(sy > YSIZE || sy < -9*CSIZE*65536) {
	     enemy[enemy_no].enemy_no = 0;
      }

      if(enemy[enemy_no].tmp2 == 0 && enemy[enemy_no].tmp1 == 0) {
	    enemy[enemy_no].tmp3 = 1;
	    andoa_flag = 0;
	    for(i = 0 ; i < 5 ; i++) 
	      if(enemy[core_enemy[i]].enemy_no == CORE)
		enemy[core_enemy[i]].enemy_no = 0;
      }

      SetSprite(enemy[enemy_no].x.sht[UNION],
		enemy[enemy_no].y.sht[UNION],
		pixmap,gc,
		9*CSIZE,9*CSIZE);
      
      return 0;
}

      



