/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Verwendet: GTK, Imlib                                                     *
 * Modul:     paul.c (main)                                                  *
 * Autor:     Andreas Tille                                                  *
 * Datum:     18.02.1998                                                     *
 * Changes:   19.03.1998: Imlib nur zur Darstellung, Laden der Dateien       *
 *                        mittels kopiertem load.c aus Imlib                 *
 *                                                                           *
 *****************************************************************************/

#include <gdk_imlib.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>
#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <X11/Xlib.h>

#include "paul.h"
#include "callback.h"

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#define  BRIGHTFILE "bright.dat"
const    char *exename;
PAUL     paul;

int usage(void)
/* Gebrauchsanweisung
 * --- Rueckgabe: ---
 * int  usage()   : immer -1
 */
{
   fprintf(stderr, "Usage: %s [<option[s]>] [image-file[s]]\n", exename);
   fputs("-a<[*c][+b]>:   enh_A_nce contrast (*c) and brightness (+b)\n", stderr);
   fputs("-b[file]:       write _B_rightnesses of all images into textfile.\n", stderr);
   fputs("-c<wxh+x+y>:    _C_ut image of width w and height h at pixel (x,y) or\n", stderr);
   fputs("  <a,b_c,d>:    area inbetween (a,b) and (c,d)\n", stderr);     
   fputs("-d[e]:          _D_ifference image (suppress \"noise\" up to e)\n", stderr);
   fputs("-e[ai]<a*b>:    search for _E_xtrema of brightness of size a*b\n", stderr);
   fputs("                -ea = only m_A_xima; -ei = only m_I_nima\n", stderr);
   fputs("-f[hvmM][i]:    median _F_ilter of order i (default: horizontal order 3)\n", stderr);
   fputs("-g<a>[e]:       make color images _G_ray\n", stderr);
   fputs("-h:             store _H_istogram in textfile\n", stderr);
   fputs("-i[a]:          print _I_nformation about images (if a is given print Gamma curve too)\n", stderr);
   fputs("-j[H]<a+b_file>:insert file at (a,b)\n", stderr);
   fputs("-m[cdf]         _M_ove images according to the first in image list.\n", stderr);
   fputs("                There are three types: _Color, _D_ifference and _F_lash.\n", stderr);
   fprintf(stderr, "                %s tries to find good matching images automatically at first.\n", 
           exename);
   fputs("-n:             _N_egativ of image\n", stderr);
   fputs("-o[PNG/TIFF]:   _O_utput of processed images in PNG or TIFF format (default PNG)\n", stderr);
   fputs("-p[hv]:         mirror _h_orizontal or _v_ertikal\n", stderr);  
   fputs("-q:             _Q_uiet: no graphic display (useful for batch jobs)\n", stderr);  
   fputs("-r[n][+s][-e]:  delete (black) bo_R_der / selectiion of real image information\n", stderr);
   fputs("                n means delete only left and right but not top and bottom border\n", stderr);
   fputs("                default: threshold for \"black\" [s] = 20\n", stderr);
   fputs("                         allowed error for one pixel [e] = 50\n", stderr);
   fputs("-s              delete (white) _S_canner border\n", stderr);
   fputs("-t<d>           ro_T_ate d degrees clockwise (d = 90, 180, 270)\n", stderr);
   fputs("-w[s]:          animate images with s seconds delay (default s=0).\n", stderr);
   fputs("-z[i]           shrink i levels (1 level means = half the width and half the height)\n", stderr);
   fputs("-F              calculate fast fourier transform of image\n", stderr);
   fputs("-H              print this _H_elp screen\n", stderr);
   return -1;
}

int main(int argc, char **argv)
{
   PAUL           paul;
   OPTIONS        popt;
   int            i;                 /* counter for different purposes         */
   char         **efiles = NULL;     /* expandierte Filenamen                  */
   register char *mp;                /* Hilfszeiger                            */
   char          *brightfile = NULL; /* Filename fr Auswertung der Helligkeit */

   const char cutorext[] = "Search for extrema and cut image isn't possible at the same time.\n",
              movorins[] = "Moving of pictures and inserting isnt possible at the same time.\n";

   MessagesInit();
   exename       = strrchr (argv[0], '/');
   if (exename) ++exename;
   else           exename = argv[0];
   paul.piclist  = paul.src = paul.activ = NULL;
   paul.op       = NULL;
   paul.filelist = NULL;
   paul.show     = paul.w = paul.ani_but = NULL;
   
   popt.f      =  0;                 /* flag what to do with this garbage       */
   popt.cut    = NULL;               /* corners of area to cut                  */
   popt.eps    =  0;                 /* "noise step" for difference images      */
   popt.fordn  =  3;                 /* order of filtering                      */
   popt.filter =  0;                 /* type of filtering                       */
   popt.greps  =  0;                 /* allowed difference between RGB values   */
   popt.mov    =  0;                 /* which type of moving images             */
   popt.shr    =  0;                 /* Stufe der Verkleinerungen               */ 
   popt.terr   =  DEFAULT_ERROR;     /* tollerierter Fehler fr Randlschen     */
   popt.thresh =  DEFAULT_THRESHOLD; /* Schwellwert fr Randlschen (-s)        */
   popt.offset =  0;                 /* offset for enhancing brightness         */
   popt.xi     =  popt.yi = -1;      /* coordinates for image to insert         */
   popt.sek    = -1.0;               /* animation delay time between two images */
   popt.scale  =  1.0;               /* factor for contrast                     */

/*************************************************************************************
 * Optionen erfassen                                                                 *
 *************************************************************************************/   
   while ( (i = getopt(argc, argv, "a:b::c:d::e:f::g::hi::j:m::no::p:qr::st:w::z::FH")) != EOF )
      switch (i) {
      case 'a': { register char *pp;
                  mp = strchr(optarg,'*');
                  if ((pp = strchr(optarg,'+')) == NULL && mp == NULL ) 
                     return usage();
                  if ( mp ) if ( sscanf(mp, "*%lg", &(popt.scale)) != 1 ) return usage();
                  if ( pp ) {
                     if ( sscanf(pp, "+%i", &i) != 1 ) return usage();
                     else popt.offset = (unsigned char)i;
		  }
                }
                break;
      case 'b': popt.f |= BRIGHT;
                if ( !optarg ) 
                   assert ( (brightfile = strdup(BRIGHTFILE)) != NULL );
                else
                   assert ( (brightfile = strdup(optarg)) != NULL );
                break;
      case 'c': if ( SaveExtrema(popt.f) ) {
	           g_warning("%s%s", cutorext, "Ignore cutting image.");
                } else 
                   if ( !( popt.cut = ReadBoxFromString(optarg) ) ) return usage();
                break;
      case 'd': popt.f |= DIFFERENZ;
                if ( !optarg ) break;
                if ( sscanf(optarg, "%i", &i) != 1 ) return usage();
                popt.eps = (unsigned char)i;
                break;
      case 'e':{ register char *ap = optarg;
                if ( popt.cut ) {
	           g_warning("%s%s", cutorext, "Ignore search for extrema.");
                } else {
                   if ( toupper(*ap) == 'A' )      { popt.f |= SAVEMAXIMA; ap++; }
                   else if ( toupper(*ap) == 'I' ) { popt.f |= SAVEMINIMA; ap++; }
                        else                         popt.f |= SAVEEXTREMA;
                   assert ( ( popt.cut = malloc(sizeof(BOX)) ) );
                   if ( sscanf(ap, "%i*%i", &(popt.cut->x2), &(popt.cut->y2)) != 2 ) return usage();
                   if ( popt.cut->x2 <= 0 || popt.cut->y2 <= 0 ) {
                      g_warning("Invalid size of section: %i*%i", popt.cut->x2, popt.cut->y2);
                      return usage();
                   }
                }
               }
                break;
      case 'f': if ( !optarg ) {
                   popt.f     |= FILTER;
                   popt.filter = 'h';
                   break;
                }
                switch ( *optarg ) {
		case 'M' : popt.filter = 'M'; break;
		case 'm' : popt.filter = 'm'; break;
		case 'v' : popt.filter = 'v'; break;
		case 'h' : 
                default  : popt.filter = 'h'; break;
		}
	        if ( (sscanf(optarg + (isdigit(*optarg)?0:1), "%i", &i)) != 1 ) popt.fordn = 3;
                else popt.fordn = (unsigned char)i;
                if ( popt.fordn < 3 || !(popt.fordn & 1) ) {
                   g_warning("Filterordnung %i ist ungltig. Keine Filterung.", popt.fordn);
                   popt.filter = 0;
		} else 
                   popt.f     |= FILTER;
                break;
      case 'g': popt.f |= MAKEGRAY;
                if ( !optarg ) popt.greps = 255;
                else { 
                   register char *pp = optarg;
                   switch ( *pp ) {
                   case 'r': popt.greps = 0; break;
                   case 'g': popt.greps = 1; break;
                   case 'b': popt.greps = 2; break;
                   case 'a': pp++; /* continue at default ! */
                   default : popt.greps = 255; 
                             if ( sscanf(pp, "%i", &i) == 1 ) {
                                if ( (popt.greps = (unsigned char)i) < 3 ) {
                                   printf("Set minimum eps to 3");
	                           popt.greps = 3;
                                }
		             }
		   }
                }
                break;
      case 'h': popt.f |= HISTOGRAMM;
                break;
      case 'i': popt.f |= INFO;
                if ( optarg && *optarg == 'a' ) popt.f |= PRINTGAMMA;
                break;
      case 'j':{ register char *ap = optarg;
                 OPTIONS  tmp;

                if ( DoMatchPictures(popt.f) ) {
	           g_warning("%s%s", movorins, "Ignore inserting picture.");
                   break;
                }
                if ( *ap == 'H' ) {
                   popt.f |= HTMLOUTPUT;
                   ++ap;
		}
                if ( sscanf(ap, "%i+%i", &(popt.xi), &(popt.yi)) != 2 ) return usage();
                if ( !(ap = strchr(ap, '_')) || !*(++ap) ) return usage();
                if ( popt.xi < 0 || popt.yi < 0 ) {
                      g_warning("Invalid coordinates to insert image: %i*%i", popt.xi, popt.yi);
                      return usage();
                }
                if ( !(paul.op = ReadPic(ap, &tmp)) ) return usage();
               }
                break;
      case 'm': if ( popt.xi > -1 ) {
	           g_warning("%s%s", movorins, "Ignore moving pictures.");
                   break;
                }
                if ( !optarg ) popt.mov = MATCHAUTO;
                else switch ( *optarg ) {
                   case 'c': popt.mov = MATCHCOL;   break;
                   case 'd': popt.mov = MATCHDIF;   break;
                   case 'f': popt.mov = MATCHFLASH; break;
                   default:  g_warning("Unbekannter Mofifikator zur Option -m (%c)", *optarg);
                             return usage();
		   }
                popt.f |= MATCHPICTURES;
                break;
      case 'n': popt.f |= NEGATIV;
                break;
      case 'o': if ( !optarg )                         SetPNG(popt.f);
                else if ( !strcasecmp(optarg, "TIF") ) SetTIFF(popt.f);
                else if ( !strcasecmp(optarg, "PNG") ) SetPNG(popt.f);
                else                                   g_warning("Unbekanntes Ausgabeformat %s.", optarg);
                break;
      case 'p': if ( strchr(optarg,'h') ) popt.f |= MIRROR_H;
                if ( strchr(optarg,'v') ) popt.f |= MIRROR_V;
                if ( *optarg != 'h' && *optarg != 'v' ) return usage();
                break;
      case 'q': popt.f |= QUIET;
                break;
      case 'r': { register char *pp;
                  /* Standardwerte setzen */
                  popt.f |= DELBORDER;
                  if ( optarg ) {
                     if ( (mp = strchr(optarg,'+')) != NULL ) {
                        if ( sscanf(mp, "+%i", &i) != 1 ) return usage();
                        popt.thresh = (unsigned char)i;
		     }
                     if ( (pp = strchr(optarg,'-')) != NULL ) {
                        if ( sscanf(pp, "-%i", &i) != 1 ) return usage();
	                popt.terr   = (unsigned char)i;
                     }
                     if ( strchr(optarg,'n') != NULL ) popt.f |= ONLYLEFTRIGHT;
		  }
                }
                break;
      case 's': popt.f |= DELSCANBORDER;
                break;
      case 't': if ( !optarg || sscanf(optarg, "%i", &i) != 1 ) return usage();
                if      ( i ==  90 ) popt.f |= ROT_90;
                else if ( i == 180 ) popt.f |= ROT_180;
                else if ( i == 270 ) popt.f |= (ROT_90 | ROT_180);
                else return usage();
                break;
      case 'w': if ( !optarg ) { popt.sek = 0; break; }
                if (sscanf(optarg, "%lg", &(popt.sek)) != 1) return usage();
                break;
      case 'z': popt.f |= SHRINK;
                if ( optarg == NULL ) break;
                if ( sscanf(optarg, "%i", &i) != 1 ) return usage();
                popt.shr = (unsigned char)i;  /* Mehr als 256 ist sinnlos */
                break;
      case 'F': popt.f |= FFT;
                break;
      case '?': g_warning("%s", optarg);
      case 'H':
      default:  return usage();
      }
   /* Ende while(getopt()) */

/*************************************************************************************
 * Kommandozeile auf Gltigkeit prfen                                               *
 *************************************************************************************/   
   efiles = argv + optind;
   if ( Differenz(popt.f) || DoMatchPictures(popt.f) ) {
      if ( argc - optind < 2 ) {
         g_warning("To build differences or to move images at least two files are necessary.");
         if ( popt.f & QUIET ) return -1;
         popt.f &= ~DIFFERENZ;
         popt.f &= ~MATCHPICTURES;
      }
   }

/*************************************************************************************
 * Read images                                                                       *
 *************************************************************************************/   
   paul.piclist = ReadPicFiles(argc - optind, efiles, &popt);
   paul.opt = &popt;
 
   if ( !(paul.piclist) && (paul.opt->f & QUIET) ) {
      g_warning("No files preloaded"); 
      PaulExit(NULL, &paul);
   }

   if ( paul.piclist && (paul.opt->f || paul.opt->scale) ) {
/*************************************************************************************
 * Bildbearbeitung                                                                   *
 *************************************************************************************/   
      if ( Filter(paul.opt->f) ) FilterBilder(&paul);
      if ( DoMakeGray(paul.opt->f) ) {
         if ( MakeGray(&paul) ) {
	    FreeBild(paul.piclist);
            return -1;
         }
      }
      if ( DelScanBorder(paul.opt->f) ) {
         if ( DeleteScannerBorder(&paul) ) {
	    FreeBild(paul.piclist);
            return -1;
         }
      }
      if ( DelBorder(paul.opt->f) ) {
         if ( SelectPictureWithoutBorder(&paul) ) {
            FreeBild(paul.piclist);
            return -1;
         }
      }
      if ( DoMatchPictures(paul.opt->f) ) {
         if ( AutoMatchPictures(&paul) ) {
            FreeBild(paul.piclist);
            return -1;
         }
      }
      if ( Differenz(paul.opt->f) ) {               /* Differenzbilder,      */
         if ( DifferenzBilder(&paul) ) {
            FreeBild(paul.piclist);
            return -1;
         }
      } else {
         if ( paul.opt->scale != 1.0 || paul.opt->offset != 0 )  /* Kontrast/Helligkeit verbessern */
            if ( SkaliereBilder(&paul) ) {
               FreeBild(paul.piclist);
               return -1;
            }
      }
      if ( SaveExtrema(paul.opt->f) ) {
         if ( Extrema(&paul) ) {
	    FreeBild(paul.piclist);
            return -1;
         }
      }
      if ( Negativ(paul.opt->f) ) MakeNegative(paul.piclist);
      if ( Mirror(paul.opt->f) ) MakeMirror(&paul);
      if ( Rotate(paul.opt->f) ) MakeRotate(&paul);
      if ( DoMatchPictures(paul.opt->f) && !IsMatchAuto(paul.opt->mov) ) {
         if ( paul.opt->f & QUIET ) {
            g_warning("Moving images without display doesn't make sense.");
            FreeBild(paul.piclist);
            return -1;
         }
         if ( CreateMatchPictures(&paul) ) {
            FreeBild(paul.piclist);
            return -1;
         }
      }
      if ( paul.opt->xi > -1 ) InsertImage(&paul);
      if ( DoFFT(paul.opt->f) ) FastFourierTransform(&paul);

/*************************************************************************************
 * Analyse image                                                                     *
 *************************************************************************************/   
      if ( Bright(paul.opt->f) )         Helligkeiten(&paul, brightfile);
      if ( HistogrammFlag(paul.opt->f) ) MakeHistograms(paul.piclist);

/*************************************************************************************
 * Bildsicherung und -information                                                    *
 *************************************************************************************/   
      if ( Info(paul.opt->f) ) PaulInfo(paul.piclist, paul.opt->f);
   
      if ( paul.opt->f & QUIET ) {
         if ( SaveBild(paul.opt->f) ) SavePictures(paul.piclist, paul.opt->f);
         FreeBild(paul.piclist);
         return 0;
      }
   } /* end if ( files loaded and options given ) */
   
/*************************************************************************************
 * Bilddarstellung                                                                   *
 *************************************************************************************/
   { /* Test, if it is possible to open X-display */
      Display *display;
   
      if ( (display = XOpenDisplay(NULL)) ) XCloseDisplay(display);
      else if ( !paul.piclist ) {
         g_warning("Unable to open display");
	 usage();
	 PaulExit(NULL, &paul);
      }
   }					

   gtk_init(&argc, &argv);
   gdk_imlib_init();

   if ( paul.piclist ) {
      CreateShowPixmaps(paul.piclist);
      if ( DoMatchPictures(paul.opt->f) && IsMatchAuto(paul.opt->mov) ) {
         PICTURE       *bild = BILD(paul.src);
         assert( (bild->im = 
                  at_imlib_set_image_from_data(bild->DATA, bild->W, bild->H)) );
      }
      GtkInterface(&paul);
   } else 
      LoadFirstPicture(&paul);
   
   gtk_main();
   PaulExit(NULL, &paul);
   return 0;
}




