/*****************************************************************************
 *                                                                           *
 * Programm:  paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Modul:     scale.c                                                        *
 *            Funktionen zur pixelweisen Bearbeitung von Bitmaps             *
 * Autor:     Andreas Tille                                                  *
 * Datum:     18.05.1998                                                     *
 *                                                                           *
 *****************************************************************************/

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "paul.h" 

#ifdef __DMALLOC__
#include <dmalloc.h>
#endif

#define SCALE(a,b)     { register int d = a; \
                         if ( d < 0    ) b = 0; \
                         else if ( d > 0xFF ) b = 0xFF; \
                              else            b = (unsigned char) d; }

int SkaliereBilder(PAUL *p)
/* contrast:   multiply all pixels with "scale"
 * brightness: add to all pixels "offset"
 * --- Parameter: ---
 * PAUL *p                : list off images, options
 *                          used options:
 *                          scale  : faktor to change contrast
 *                          offset : shift to change brightness
 * --- Rueckgabe: ---
 * int   SkaliereBilder() : 0 if OK, -1 in case of error
 */
{
   PICTURE       *bild;
   GList         *pl;
   char           kontrast[512], *buf,
                 *loss_off = "%s of %g causes loss of information!";
   unsigned char *c, *fcp;
   double         scale;
   register int   offset;

   if ( !NBILDER(p->piclist) ) return 0;

   offset = p->opt->offset;
   if ( (scale  = p->opt->scale) > 0.9999 && scale < 1.0001 && !offset ) return 0;
   
   if ( fabs(scale) < 1.0 || fabs(scale) > 4.0 )
      g_warning(loss_off, "Contrast", scale);
   if ( (scale > 0.0 && abs(offset) > 128) || abs(offset) > 256 )
      g_warning(loss_off, "Brightness", offset);

   for ( bild = BILD(pl = p->piclist); pl; bild = BILD(pl = pl->next) ) {
      CopySpec(bild->spec, ChunkNameTyp, TypKontrastBild);
      if ( !(buf = GetSpec(bild->spec, ChunkNameSource)) ) buf = "";
      sprintf(kontrast, "%s contrast factor *%g, brightness offset +%i", buf, scale, offset);
      CopySpec(bild->spec, ChunkNameDescription, kontrast);
      NewFileName(bild, APPKONTRAST);

      for ( fcp = (c = bild->DATA) + bild->storepix*bild->size; c < fcp; c++ ) 
         SCALE( (int)(((double)*c) * (scale)) + offset, *c );
      
   }
   return 0;
}






