#include "config.h"
#include <stdio.h>
#include <sys/types.h>
#include <setjmp.h>
#include "common.h"
#include "command.h"
#ifdef X68
#include "tty_x68.h"
#else
#ifdef WIN32
#include "tty_w32.h"
#else
#include "tty.h"
#include <termios.h>
#endif
#endif
#if HAVE_UNISTD_H
#include <unistd.h>
#endif

extern int verbose;

/*------------------------------------------------------------*/
int
QVputcam(n, size, buf)
     int	n;
     int        size;
     u_char	*buf;
{
  u_char	s;
  int	len;

  /* drain */
  if (!QVok())
    return -1;			/*ng*/

  wstr("MH", 2);
  s = rbyte();
  wbyte(ACK);

  s = rbyte();			/*?*/

  if (verbose)
      fprintf(stderr, "Picture   %3d: ", n);

  len = QVblocksend(buf, size);
  if(len == -1)
    return -1;

  wbyte(ENQ);
  wstr("DJ", 2);
  s = rbyte();			/*?*/
  wbyte(ACK);

  return len;
}



/*------------------------------------------------------------*/
int
QVputpicture(n, size, buf)
     int	n;
     int        size;
     u_char	*buf;
{
  u_char	s;
  int	len;

  /* drain */


  if (!QVok())
    return -1;			/*ng*/

  if (!QVok())
    return -1;			/*ng*/
  wstr("MM", 2);
  s = rbyte();

  wbyte(ACK);
  s = rbyte();			/* may be 0x12 */

  if (verbose)
      fprintf(stderr, "Picture   %3d: ", n);

  len = QVblocksend(buf, size);
  if(len == -1)
    return -1;

  if (!QVok())
    return -1;			/*ng*/
  wstr("DN",2);
  s = rbyte();			/*?*/
  wbyte(ACK);

  if (!QVok())
    return -1;			/*ng*/
  wstr("DJ",2);
  s = rbyte();			/*?*/
  wbyte(ACK);

  return len;
}



