#include "Python.h"
#include "arrayobject.h"
#include "ranlib.h"

static PyObject *ErrorObject;

/* ----------------------------------------------------- */

static char random_sample__doc__[] ="";

static PyObject *
random_sample(PyObject *self, PyObject *args)
{
  PyArrayObject *op;
  double *dptr;
  int i, n=-1, nd;

  if (!PyArg_ParseTuple(args, "|i", &n)) return NULL;

  /*Create a 1 dimensional array of dimensions of type double*/
  nd = n == -1 ? 0:1;
  op = (PyArrayObject *)PyArray_FromDims(1, &n, PyArray_DOUBLE);
  if (op == NULL) return NULL;

  if (n == -1) n = 1;
  dptr = (double *)op->data;
  for(i=0; i<n; i++) {
    *dptr = ranf();
    dptr++;
  }

  return PyArray_Return(op);
}

static PyObject *
random_set_seeds(PyObject *self, PyObject *args)
{
  long seed1, seed2;

  if (!PyArg_ParseTuple(args, "ll", &seed1, &seed2)) return NULL;


  setall(seed1, seed2);
  if (PyErr_Occurred ()) return NULL;
  Py_INCREF(Py_None);
  return (PyObject *)Py_None;
}

static PyObject *
random_get_seeds(PyObject *self, PyObject *args)
{
  long seed1, seed2;

  if (!PyArg_ParseTuple(args, "")) return NULL;

  getsd(&seed1, &seed2);

  return Py_BuildValue("ll", seed1, seed2);
}

/* List of methods defined in the module */

static struct PyMethodDef random_methods[] = {
 {"sample",	random_sample,	1,	random_sample__doc__},
 {"set_seeds",	random_set_seeds,	1, },
 {"get_seeds",	random_get_seeds,	1, },
 {NULL,		NULL}		/* sentinel */
};


/* Initialization function for the module (*must* be called initfftpack) */

static char random_module_documentation[] = 
""
;

void
initranlib()
{
	PyObject *m, *d;

	/* Create the module and add the functions */
	m = Py_InitModule4("ranlib", random_methods,
		random_module_documentation,
		(PyObject*)NULL,PYTHON_API_VERSION);

	/* Import the array object */
	import_array();

	/* Add some symbolic constants to the module */
	d = PyModule_GetDict(m);
	ErrorObject = PyString_FromString("ranlib.error");
	PyDict_SetItemString(d, "error", ErrorObject);

	/* XXXX Add constants here */
	
	/* Check for errors */
	if (PyErr_Occurred())
		Py_FatalError("can't initialize module ranlib");
}




