""" 
Script to install the Numeric files.  Assumes shared objects have
been built already -- should check somehow...

First public release -- please let us know of bugs or failures.

[david ascher - July 21, 1998]
"""

import glob, shutil, os, sys

def mkrecursivedir(libdir):
    path, tail = os.path.split(libdir)
    if tail != '':
        mkrecursivedir(path)
    if not os.path.exists(libdir):
        print "#making directory", libdir
        os.mkdir(libdir)
    elif not os.path.isdir(libdir):
        print "Oops! recursive mkdir failed: %s is not a directory!" % libdir
        type, value = sys.exc_info[:2]
        raise type, value
    
def do_install():
    global MODE
    if MODE == None:
        # determime the mode of the files in their target directory
        origumask = os.umask(0) ; os.umask(origumask)  # leave unchanged
        MODE = 0666 ^ origumask    # this will be 0644 or 0664 in most cases

    if len(sys.argv) == 1:
        if sys.platform not in ('win32', 'mac'):
            libdir = os.path.join(os.path.join(sys.exec_prefix, 'lib'),
                                  'python'+sys.version[:3], LIBDIR)
        else:
            libdir = os.path.join(os.path.split(sys.exec_prefix)[0],
                                  'LLNLDistribution', LIBDIR)

    elif len(sys.argv) == 2:
       libdir = sys.argv[-1]
    else:
       print "\nUsage: python installthis.py [_targetdir_]"
       print "\nwhere _targetdir_ is the directory for the .py files."
       print "This directory should be added to the PYTHONPATH."
       print "The default for _targetdir_ is: %s" % libdir
       sys.exit()

    if not os.path.exists (libdir):
        mkrecursivedir(libdir)
    else:
        print "# We'll use the %s directory." % libdir

    if sys.platform == 'win32':
        for fname in glob.glob(os.path.join('pyds', '*.pyd')):
            target = os.path.join(libdir, os.path.split(fname)[1])
            os.chmod(fname, MODE)
            shutil.copy(fname, target)
    else:
        if globals().has_key('MAKEINSTALL') and MAKEINSTALL: 
            print "# Installing the shared libraries with 'make install'"
            os.system('make install')


    print "# Installing the .py and .pyc files in %s" % libdir
    for dir in DIRS:
        fnames = glob.glob(os.path.join(dir, '*.py')) + \
                 glob.glob(os.path.join(dir, '*.pyc')) 
        for fname in fnames:
            os.chmod(fname, MODE)
            target = os.path.join(libdir, os.path.split(fname)[1])
            shutil.copy(fname, target)

    if libdir not in sys.path:
        print "# Make sure to add %s to your PYTHONPATH." % libdir

    dsodir = libdir
    print "# Installing the DSO files (.so or .sl) in %s " % dsodir
    for dso in glob.glob('*.so'):
        target = os.path.join(dsodir, os.path.split(dso)[1])
        shutil.copy(dso, dsodir)
    for dso in glob.glob('*.sl'):
        target = os.path.join(dsodir, os.path.split(dso)[1])
        shutil.copy(dso, dsodir)

# Look for platform-specific 'patch' file to run before we
# actually make anything
if globals().has_key('toolsdir'):
    patchfile = os.path.join(toolsdir, sys.platform+'-install.py')
    if os.path.exists(patchfile):
        execfile(patchfile)

do_install()

