#ifndef MXSTACK_H
#define MXSTACK_H
#ifdef __cplusplus
extern "C" {
#endif

/* 
  mxStack -- A stack implemenation

  (c) Marc-Andre Lemburg; all rights reserved
*/

/* The extension's name */
#define MXSTACK_MODULE "mxStack"

/* --- No servicable parts below this line ----------------------*/

/* Include generic mx extension header file */
#include "mxh.h"

#ifdef MX_BUILDING_MXSTACK
# define MXSTACK_EXTERNALIZE MX_EXPORT
#else
# define MXSTACK_EXTERNALIZE MX_IMPORT
#endif

/* --- Stack Object ------------------------------------------*/

typedef struct {
    PyObject_HEAD
    int size;			/* Number of items allocated */
    int top;			/* Index of top element */
    PyObject **array;		/* Pointer to the stack array */
} mxStackObject;

/* Type checking macro */

#define mxStack_Check(v) \
        (((mxStackObject *)(v))->ob_type == mxStack.Stack_Type)

/* Some (unsafe) macros to access the most important parts */

#define mxStack_GET_SIZE(v) (((mxStackObject *)v)->top+1)
#define mxStack_GET_ITEM(v,i) (((mxStackObject *)v)->stack[i])

/* --- C API ----------------------------------------------------*/

/* C API for usage by other Python modules */
typedef struct {
	 
    /* Type object for Stack() */
    PyTypeObject *Stack_Type;

    /* Create a new empty stack object with at least size entries
       alredy allocated. */
    mxStackObject *(*mxStack_New)(int size);

    /* Create a new empty stack object from the sequence v */
    mxStackObject *(*mxStack_FromSequence)(PyObject *v);

    /* Push a Python object onto the stack. The reference count is increased
       by one. Stacks only grow, they never shrink again. */
    int (*mxStack_Push)(mxStackObject *stack,
			PyObject *v);
    
    /* Pop an object from the stack. Ownership is passed to the caller.
       Note: This doesn't cause the allocated stack size to change. */
    PyObject *(*mxStack_Pop)(mxStackObject *stack);
    
    /* Return a the stacks content as tuple. */
    PyObject *(*mxStack_AsTuple)(mxStackObject *stack);
    
    /* Return a the stacks content as list. */
    PyObject *(*mxStack_AsList)(mxStackObject *stack);

} mxStackModule_APIObject;

#ifndef MX_BUILDING_MXSTACK

/* Interfacestructure to C API for other modules.
   Call mxStack_ImportModuleAPI() to initialize this
   structure. After that usage is simple:

   PyObject *v;
	
   v = mxStack.Stack_New(0);
   if (!v)
       goto onError;
   ...

*/

static 
mxStackModule_APIObject mxStack;

/* You *must* call this before using any of the functions in
   mxStack and check its outcome; otherwise all accesses will
   result in a segfault. Returns 0 on success. */

static
int mxStack_ImportModuleAndAPI(void)
{
    PyObject *mod, *v = 0;
    void *api;
    
    mod = PyImport_ImportModule(MXSTACK_MODULE);
    if (mod == NULL)
	return -1;
    v = PyObject_GetAttrString(mod,MXSTACK_MODULE"API");
    if (v == NULL)
	goto onError;
    api = PyCObject_AsVoidPtr(v);
    if (api == NULL)
	goto onError;
    Py_DECREF(mod);
    Py_DECREF(v);
    memcpy(&mxStack,api,sizeof(mxStack));
    return 0;
    
 onError:
    Py_XDECREF(mod);
    Py_XDECREF(v);
    return -1;
}

#endif

/* EOF */
#ifdef __cplusplus
}
#endif
#endif
