/* $Id: match-color.c,v 1.4 1998/09/26 03:07:47 marcus Exp $
***************************************************************************

   Common palette-matching code

   Copyright (C) 1998 Andrew Apted  [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

int _ggi_match_palette(ggi_color *pal, int pal_len, ggi_color *col)
{
	int i, closest=0;

	unsigned int closest_dist = (1 << 24) * 4;

	for (i=0; i < pal_len; i++) {

		int dr = (col->r - pal[i].r) >> 4;
		int dg = (col->g - pal[i].g) >> 4;
		int db = (col->b - pal[i].b) >> 4;

		int dist = (dr*dr) + (dg*dg) + (db*db);

		if (dist < closest_dist) {
			closest = i;
			closest_dist = dist;
		}

		if (closest_dist == 0) {
			/* direct hit */
			break;
		}
	}

	DPRINT_COLOR("match-color: %02x%02x%02x -> %02x%02x%02x.\n",
		     col->r >> 8, col->g >> 8, col->b >> 8,
		     pal[closest].r >> 8, pal[closest].g >> 8,
		     pal[closest].b >> 8);

	return closest;
}
