/* $Id: visual.c,v 1.2 1998/10/29 13:20:44 marcus Exp $
***************************************************************************

   LibGGI - kgicon specific overrides for fbcon
   Initialization

   Copyright (C) 1998 Marcus Sundberg	[marcus@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include "genkgi.h"


static int refcount = 0;
int _ggi_genkgi_prividx = -1;

int GGIdlinit(ggi_visual *vis, const char *version, void *argptr)
{
	int idx = -1;
	struct genkgi_priv *priv;
	
	if (refcount == 0) {
		idx = _ggi_alloc_drvpriv();
		if (idx < 0) {
			return GGI_DL_ERROR;
		}
		_ggi_genkgi_prividx = idx;
	}
	
	priv = _ggi_malloc(sizeof(struct genkgi_priv));

	priv->fd = LIBGGI_FD(vis);
		
	if ((priv->mapped_gc = (ggi_gc *) mmap(NULL, 4096,
					       PROT_READ|PROT_WRITE,
					       MAP_SHARED, priv->fd,
					       MMAP_TYPE_GC))
	    == (void *)-1) {
		/* Can't mmap() GC - assume we are not on a KGI driver */
		free(priv);
		if (idx > -1) {
			_ggi_free_drvpriv(idx);
		}
		return GGI_DL_ERROR;
	}
	
	LIBGGI_GC(vis) = priv->mapped_gc;
	refcount++;
	
	priv->drawline = vis->opdraw->drawline;
	priv->drawbox = vis->opdraw->drawbox;
	priv->copybox = vis->opdraw->copybox;
	priv->fillscreen = vis->opdraw->fillscreen;
	
	vis->opdraw->drawline = GGI_genkgi_drawline;
	vis->opdraw->drawbox = GGI_genkgi_drawbox;
	vis->opdraw->copybox = GGI_genkgi_copybox;
	vis->opdraw->fillscreen = GGI_genkgi_fillscreen;

	LIBGGI_DRVPRIV(vis, _ggi_genkgi_prividx) = priv;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *vis)
{
	munmap((void*) GENKGI_PRIV(vis)->mapped_gc, 4096);
	
	free(GENKGI_PRIV(vis));
		
	refcount--;
	if (refcount == 0) {
		_ggi_free_drvpriv(_ggi_genkgi_prividx);
		_ggi_genkgi_prividx = -1;
	}
                
	return 0;
}
		
#include <ggi/internal/ggidlinit.h>
