/* $Id: hline.c,v 1.7 1998/09/20 21:22:42 marcus Exp $
***************************************************************************

   Graphics library for GGI. Horizontal lines.

   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <string.h>

#include <ggi/internal/ggi-dl.h>

/**********************************/
/* draw/get/put a horizontal line */
/**********************************/

int GGIdrawhline(ggi_visual *vis,int x,int y,int w)
{
	uint32 colors[3],*bla,i;
	uint8 *colp =(uint8 *)colors, *foo;
	
	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w<=0) return 0;

	foo=(uint8 *)LIBGGI_CURWRITE(vis)+
		(y*LIBGGI_FB_W_STRIDE(vis)+x*3);
	while(((x)&3)&&w)
	{  
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		x++;w--;
	};
	for (i=0;i<4;i++) 
	{
		*colp++=(LIBGGI_GC_FGCOLOR(vis));
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>16);
	}
	bla=(uint32 *)foo;
	while (w>3) {
		*bla++=colors[0];
		*bla++=colors[1];
		*bla++=colors[2];
		w-=4;
	};
	foo=(uint8 *)bla;
	while (w) {
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		w--;
	};
	return 0;
}

int GGIdrawhline_nc(ggi_visual *vis,int x,int y,int w)
{
	uint32 colors[3],*bla,i;
	uint8 *colp =(uint8 *)colors, *foo;
	
	foo=(uint8 *)LIBGGI_CURWRITE(vis)+
		(y*LIBGGI_FB_W_STRIDE(vis)+x*3);
	while(((x)&3)&&w)
	{  
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		x++;w--;
	};
	for (i=0;i<4;i++) 
	{
		*colp++=(LIBGGI_GC_FGCOLOR(vis));
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*colp++=(LIBGGI_GC_FGCOLOR(vis)>>16);
	}
	bla=(uint32 *)foo;
	while (w>3) {
		*bla++=colors[0];
		*bla++=colors[1];
		*bla++=colors[2];
		w-=4;
	};
	foo=(uint8 *)bla;
	while (w) {
		*foo++=(LIBGGI_GC_FGCOLOR(vis));
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>8);
		*foo++=(LIBGGI_GC_FGCOLOR(vis)>>16);
		w--;
	};
	return 0;
}

int GGIputhline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	CHECKXYW(vis,x,y,w);

	/* Clipping */
	if (y<(LIBGGI_GC(vis)->cliptl.y) || y>=(LIBGGI_GC(vis)->clipbr.y)) return 0;
	if (x< (LIBGGI_GC(vis)->cliptl.x)) {
		int diff=(LIBGGI_GC(vis)->cliptl.x)-x;
		x+=diff;
		w-=diff;
		buffer=((char *)buffer)+3*diff;
	}
	if (x+w>(LIBGGI_GC(vis)->clipbr.x)) {
		w=(LIBGGI_GC(vis)->clipbr.x)-x;
	}
	if (w>0) {
		memcpy((uint8 *)LIBGGI_CURWRITE(vis)+
		       (y*LIBGGI_FB_W_STRIDE(vis)+x*3),buffer,w*3);
	}
	return 0;
}

int GGIgethline(ggi_visual *vis,int x,int y,int w,void *buffer)
{ 
	memcpy(buffer,(uint8 *)LIBGGI_CURREAD(vis)+
	       (y*LIBGGI_FB_R_STRIDE(vis)+x*3),w*3);

	return 0;
}
