/* $Id: vline.c,v 1.8 1998/09/20 21:22:53 marcus Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1997 Jason McMullan [jmcc@ggi-project.org]
   Copyright (C) 1995 Andreas Beck [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/ggi-dl.h>

/********************************/
/* draw/get/put a vertical line */
/********************************/
int GGIdrawvline(ggi_visual *vis,int x,int y,int height)
{
	uint32 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	ggi_pixel color=LIBGGI_GC_FGCOLOR(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr = (uint32*) ((uint8 *)LIBGGI_CURREAD(vis)+y*w+x*sizeof(uint32));

	for(;height>0;height--,ptr = (uint32*) ((uint8 *)ptr + w))
		*ptr=color; 
	
	return 0;
}

int GGIdrawvline_nc(ggi_visual *vis,int x,int y,int height)
{
	uint32 *ptr;
	int w=LIBGGI_FB_W_STRIDE(vis);
	ggi_pixel color=LIBGGI_GC_FGCOLOR(vis);

	ptr = (uint32*) ((uint8 *)LIBGGI_CURREAD(vis)+y*w+x*sizeof(uint32));

	for(;height>0;height--,ptr = (uint32*) ((uint8 *)ptr + w)) 
		*ptr=color; 
	
	return 0;
}

int GGIputvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint32 *ptr,*pixels=(uint32 *)buffer;
	int w=LIBGGI_FB_W_STRIDE(vis);

	/* Clipping */
	if (x< (LIBGGI_GC(vis)->cliptl.x) ||
	    x>=(LIBGGI_GC(vis)->clipbr.x)) return 0;
	if (y< (LIBGGI_GC(vis)->cliptl.y)) {
		int diff=(LIBGGI_GC(vis)->cliptl.y)-y;
		y     +=diff;
		height-=diff;
		buffer =((uint32 *)buffer)+diff;
	}
	if (y+height>(LIBGGI_GC(vis)->clipbr.y)) {
		height=(LIBGGI_GC(vis)->clipbr.y)-y;
	}

	ptr = (uint32*) ((uint8 *)LIBGGI_CURREAD(vis)+y*w+x*sizeof(uint32));

	for(;height>0;height--,ptr = (uint32*) ((uint8 *)ptr + w)) 
		*ptr=*(pixels++); 
	
	return 0;
}

int GGIgetvline(ggi_visual *vis,int x,int y,int height,void *buffer)
{
	uint32 *ptr,*pixels=(uint32 *)buffer;
	int w=LIBGGI_FB_R_STRIDE(vis);

	ptr = (uint32*) ((uint8 *)LIBGGI_CURREAD(vis)+y*w+x*sizeof(uint32));

	for(;height>0;height--,ptr = (uint32*) ((uint8 *)ptr + w))
		*(pixels++)=*ptr; 
	
	return 0;
}

