/* $Id: visual.c,v 1.14 1998/10/18 15:52:30 becka Exp $
***************************************************************************

   Graphics library for GGI.

   Copyright (C) 1995 Andreas Beck     [becka@ggi-project.org]
   Copyright (C) 1997 Jason McMullan   [jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "lin8lib.h"

int GGIdlinit(ggi_visual *visual,const char *version,void *argptr)
{
	/* Frame handling
	 */

	visual->opdraw->setreadframe=GGI_default_setreadframe;
	visual->opdraw->setwriteframe=GGI_default_setwriteframe;
	
	/* Generic drawing
	 */
        visual->opdraw->putc=GGI_lin8_putc;
        /* puts is inherited from the generic stubs */

	visual->opdraw->drawpixel_nc=GGI_lin8_drawpixel_nc;
	visual->opdraw->drawpixel=GGI_lin8_drawpixel;
	visual->opdraw->putpixel_nc=GGI_lin8_putpixel_nc;
	visual->opdraw->putpixel=GGI_lin8_putpixel;
	visual->opdraw->getpixel=GGI_lin8_getpixel;

	visual->opdraw->drawhline_nc=GGI_lin8_drawhline_nc;
	visual->opdraw->drawhline=GGI_lin8_drawhline;
	visual->opdraw->puthline=GGI_lin8_puthline;
	visual->opdraw->gethline=GGI_lin8_gethline;

	visual->opdraw->drawvline_nc=GGI_lin8_drawvline_nc;
	visual->opdraw->drawvline=GGI_lin8_drawvline;
	visual->opdraw->putvline=GGI_lin8_putvline;
	visual->opdraw->getvline=GGI_lin8_getvline;

	visual->opdraw->drawline=GGI_lin8_drawline;
	visual->opdraw->copybox=GGI_lin8_copybox;

	return GGI_DL_OPDRAW;
}

int GGIdlcleanup(ggi_visual *visual)
{
	return 0;
}

#include <ggi/internal/ggidlinit.h>
