/*
 * showaccel2.c - (c) 1998 Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#ifdef __linux__
#include <linux/vt.h>
#endif __linux__
#include <string.h>
#include <ggi/ggi.h>

ggi_color pal[256];

ggi_visual_t vis;

int randnum(int max)
{ return (rand()%max); }

static inline int slow_drawbox(int x,int y,int w,int h)
{ while(h--) ggiDrawHLine(vis,x,y++,w); return 0; }

int main(int argc, char *argv[])
{
  int t,x,c,y;
  int sx[]={1600,1280,1280,1024,1024,800,640,640,640,640,640,320,320,320,160};
  int sy[]={1200,1280, 960,1024, 768,600,480,400,200,100, 50,240,200,100,120};

  if (ggiInit() != 0) {
	  fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
		  argv[0]);
	  exit(1);
  }
  if ((vis=ggiOpen(NULL)) == NULL) {
	  fprintf(stderr,
		  "%s: unable to open default visual, exiting.\n",
		  argv[0]);
	  exit(1);
  }
         
  t=7;

   if (ggiSetGraphMode(vis, sx[t], sy[t], GGI_AUTO, GGI_AUTO, GT_AUTO)) return 0;
   printf("Mode OK:%dx%d\n",sx[t],sy[t]);

   ggiSetGCForeground(vis,0);
   ggiFillscreen(vis);

   for(c=0;c<256;c++)
    { pal[c].r=c*256;pal[c].g=256*(255-c);
      pal[c].b=(128-abs(128-c))*7*64; }
   ggiSetPalette(vis,0,256,pal);
   
   switch(fork())
   { case 0:
       for(x=0;x<50000;x++)
       { ggiSetGCForeground(vis,randnum(256));
         ggiDrawBox(vis,randnum(sx[t]/4),randnum(sy[t]/2),
      		     randnum(sx[t]/4),randnum(sy[t]/2));
       } exit(0);
     default:
       for(x=0;x<50000;x++)
       { ggiSetGCForeground(vis,randnum(256));
         slow_drawbox(randnum(sx[t]/4)+sx[t]/2,randnum(sy[t]/2),
     		      randnum(sx[t]/4)        ,randnum(sy[t]/2));
       }
    }
  ggiClose(vis);
  ggiExit();
  return(0);
}
