/*
 * sndshow.c - (c) 1998 Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/mman.h>
#ifdef __linux__
#include <linux/vt.h>
#include <linux/soundcard.h>
#endif
#include <string.h>
#include <ggi/ggi.h>

#define samplen 512*2

unsigned char buffer[samplen],old[samplen];

struct minmax { int min,max; };

ggi_visual_t vis;

ggi_uint red,yellow,green,black;

void draw_vu(int xp,int width,struct minmax mm)
{   
    ggiSetGCForeground(vis,green);
		    ggiDrawBox(vis,xp,mm.min+1,width,mm.max-mm.min);
    ggiSetGCForeground(vis,yellow);
    if (mm.min< 20) ggiDrawBox(vis,xp,mm.min+1,width,20-mm.min);
    if (mm.max>235) ggiDrawBox(vis,xp,235   +1,width,mm.max-235);
    ggiSetGCForeground(vis,red);
    if (mm.min< 10) ggiDrawBox(vis,xp,mm.min+1,width,10-mm.min);
    if (mm.max>245) ggiDrawBox(vis,xp,245   +1,width,mm.max-245);
}

int main(int argc, char **argv)
{ int handle,x,y,p;
  int subdivval=4;
  int speed=44000;
  ggi_color map;
  
  struct minmax akt,chain[7];
  
  akt.min=0;akt.max=0;

  if (argc>1)
  { if ((handle=open(argv[1],O_RDONLY|O_NDELAY))==-1) exit(1); }
  else
  { if ((handle=open("/dev/dsp",O_RDONLY|O_NDELAY))==-1) exit(1);

#ifdef __linux__
    ioctl(handle,SNDCTL_DSP_RESET   ,NULL);
    ioctl(handle,SOUND_PCM_SUBDIVIDE,&subdivval);
    ioctl(handle,SOUND_PCM_WRITE_RATE,&speed);
#endif
  }
    
  if (ggiInit() != 0) {
	  fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
		  argv[0]);
	  exit(1);
  }
  if ((vis=ggiOpen(NULL)) == NULL) {
	  fprintf(stderr,
		  "%s: unable to open default visual, exiting.\n",
		  argv[0]);
	  exit(1);
  }
         
  if (ggiSetGraphMode(vis,GGI_AUTO,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_AUTO))
    ggiPanic("Cannot open default mode.");
    
  map.r=map.g=map.b=0;
  black=ggiMapColor(vis, &map);
  map.r=0xffff;map.g=map.b=0;
  red  =ggiMapColor(vis, &map);
  map.r=0;map.g=0xffff;map.b=0;
  green=ggiMapColor(vis, &map);
  map.r=0xffff;map.g=0xffff;map.b=0;
  yellow=ggiMapColor(vis, &map);

  ggiSetGCForeground(vis,black);p=0;
  ggiFillscreen(vis);
  ggiSetGCForeground(vis,red);
  ggiDrawHLine(vis,0,  0,540);
  ggiDrawHLine(vis,0,257,540);  
  ggiDrawVLine(vis,0,  0,258);
  ggiDrawVLine(vis,513,0,258);
  ggiDrawVLine(vis,540,0,258);

  for(x=0;x<7;x++)
  { chain[x].min=chain[x].max=128; }

  while(1)
  { memcpy(old,buffer,sizeof(old));
    memcpy(buffer,buffer+samplen,sizeof(buffer)-samplen);
    read(handle,buffer+sizeof(buffer)-samplen,samplen);
    ggiSetGCForeground(vis,2);
    akt.min=255;akt.max=0;
#if 0
    for(x=y=0;x<512;x++,y+=samplen/512) 
    { if (buffer[y]<akt.min) akt.min=buffer[y]; 
      if (buffer[y]>akt.max) akt.max=buffer[y];
      ggiPutPixel(vis,x+1,1+old[y]   ,black);
      ggiPutPixel(vis,x+1,1+buffer[y],green); }
#else
    for(x=y=0;x<511;x++,y+=samplen/512)
    { if (buffer[y]<akt.min) akt.min=buffer[y];
      if (buffer[y]>akt.max) akt.max=buffer[y];
      ggiSetGCForeground(vis,black);
      if (old[y + samplen/512] >= old[y]) {
	ggiDrawVLine(vis, x+1, 1 + old[y],
			1+(old[y+ samplen/512] - old[y]));
      }
      else {
	ggiDrawVLine(vis, x+1, 1 + old[y+samplen/512],
			1+(old[y] - old[y+samplen/512]));
      }
      ggiSetGCForeground(vis,green);
      if (buffer[y+samplen/512] >= buffer[y]) {
	ggiDrawVLine(vis, x+1, 1 + buffer[y],
			1+(buffer[y+samplen/512] - buffer[y]));
      }
      else {
        ggiDrawVLine(vis, x+1, 1 + buffer[y+samplen/512],
			1+(buffer[y] - buffer[y+samplen/512]));
      }
    }
#endif
    ggiSetGCForeground(vis,black);
    ggiDrawBox(vis,515,1,23,256);
    draw_vu(515,6,akt);
    for(x=0;x<7;x++)
    { if (akt.min<chain[x].min) chain[x].min=akt.min;
      if (akt.max>chain[x].max) chain[x].max=akt.max;
      draw_vu(524+x+x,2,chain[x]);
      chain[x].min=((int)chain[x].min*(80-x-x)+(int)(x+x+2)*akt.min+81)/82;
      chain[x].max=((int)chain[x].max*(80-x-x)+(int)(x+x+2)*akt.max)/82;
    }
  }

  ggiClose(vis);
  ggiExit();
  
  close(handle);
  
  return(0);
}
