/* $Id: joystick.inc,v 1.3 1998/09/20 21:27:03 steve Exp $
***************************************************************************

   Linux_common/joystick.c
   Linux joystick handling code.

   Copyright (C) 1998  Andrew Apted  <andrew.apted@ggi-project.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ---------------------------------------------------------------------

   USAGE:

	1. Define JOYSTICK_FD(vis) to be a variable (type: int) which
	can be used to hold the joystick file descriptor, and initialize
	it to NULL for good measure.
	
	2. Define JOYSTICK_PRIV(vis) to be a variable (type: void *)
	where some private information can be stored.  Initialize the
	pointer to NULL for good measure.

	3. Call joystick_init(vis).  The will open the joystick device
	and initialize everything.  Returns 0 if successful.

	4. When joystick data is available (e.g. by using select on
	JOYSTICK_FD(vis)), call joystick_handle_data(vis).  This will
	read data from the joystick device, convert them to GGI joystick
	events, and add them to the event queue.

	5. When finished, call joystick_exit(vis), which will do any
	restorations and close the joystick device.

***************************************************************************
*/

#include <termios.h>

#include <sys/time.h>
#include <sys/types.h>
#include <sys/ioctl.h>

#include <linux/joystick.h>


#define JOYSTICK_MAX_AXES  8

typedef struct joystick_hook
{
	int cur_buttons;
	int cur_axes[JOYSTICK_MAX_AXES];

} JoystickHook;

#define JOYSTICK_HOOK(vis)  ((JoystickHook *) JOYSTICK_PRIV(vis))


void joystick_init(ggi_visual *vis)
{
	struct termios new;

	/* allocate joystick hook */

	JOYSTICK_PRIV(vis) = _ggi_malloc(sizeof(JoystickHook));

	/* blah blah blah... */
	
	DPRINT("L/joystick: init OK.\n");
}


void joystick_exit(ggi_visual *vis)
{
	if (JOYSTICK_FD(vis) >= 0) {

		/* blah blah blah... */

		/* free joystick hook */

		free(JOYSTICK_PRIV(vis));
	}

	DPRINT("L/joystick: exit OK.\n");
}


void joystick_handle_data(ggi_visual *vis)
{
	ggi_event joy_event;

	int old_buttons = JOYSTICK_HOOK(vis)->cur_buttons;

	int change_buttons=0;
	int change_axes=0;


	/* first get some data */

	if (read(JOYSTICK_FD(vis), buf, 1) < 1) {
		DPRINT("L/joystick: Error reading joystick.\n");
		return;
	}

	
	/* !!! blah blah blah..., probably loop */
	

	if (was a button) {
		
		JOYSTICK_HOOK(vis)->cur_buttons set/unset the button bit;

		change_buttons=1;
		
	} else {
	
		JOYSTICK_HOOK(vis)->cur_axes[axis num] = axis value;

		change_axes=1;
	}


	if (old_buttons != JOYSTICK_HOOK(vis)->cur_buttons) {

		joy_event.any.size = sizeof(ggi_joybut_event);
		joy_event.any.type = evJoyButton;
		joy_event.any.origin = EV_ORIGIN_NONE;
		joy_event.any.target = EV_TARGET_NONE;

		joy_event.joybut.button = button number;

		EV_TIMESTAMP(& joy_event);

		_ggiEvQueueAdd(vis, &joy_event);
	}

	if (old_buttons != JOYSTICK_HOOK(vis)->cur_buttons) {

		joy_event.any.size = sizeof(ggi_joyabs_event);
		joy_event.any.type = evJoyAbsolute;
		joy_event.any.origin = EV_ORIGIN_NONE;
		joy_event.any.target = EV_TARGET_NONE;

		/* !!! fill in current axis values */

		joy_event.joyabs.axis[axis num] = axis value;
		EV_TIMESTAMP(& joy_event);

		_ggiEvQueueAdd(vis, &joy_event);
	}
}
