/* $Id: aavisual.h,v 1.14 1998/10/06 20:00:36 steve Exp $
***************************************************************************

   Headers for AA target.

   Copyright (C) 1997 Andreas Beck    [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#ifndef _GGI_AAVISUAL_H
#define _GGI_AAVISUAL_H

#include <aalib.h>
#include <ggi/internal/ggi-dl.h>
#include "../mansync/mansync.h"

ggifunc_flush		GGI_aa_flush;
ggifunc_getmode		GGI_aa_getmode;
ggifunc_setmode		GGI_aa_setmode;
ggifunc_checkmode	GGI_aa_checkmode;
ggifunc_getapi 		GGI_aa_getapi;
ggifunc_setflags	GGI_aa_setflags;

ggifunc_eventpoll	GGI_aa_eventpoll;
ggifunc_eventread	GGI_aa_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_setpalvec	GGI_aa_setpalvec;

#define AA_PRIV(vis) ((struct AAhooks *)LIBGGI_PRIVATE(vis))

#define MANSYNC_init(vis)   AA_PRIV(vis)->opmansync->init(vis)
#define MANSYNC_deinit(vis) AA_PRIV(vis)->opmansync->deinit(vis)
#define MANSYNC_start(vis)  AA_PRIV(vis)->opmansync->start(vis)
#define MANSYNC_stop(vis)   AA_PRIV(vis)->opmansync->stop(vis)
#define MANSYNC_ignore(vis) AA_PRIV(vis)->opmansync->ignore(vis)
#define MANSYNC_cont(vis)   AA_PRIV(vis)->opmansync->cont(vis)

struct AAhooks { 
	aa_context *context;
	aa_palette pal;
	ggi_mutex aalock;
	_ggi_opmansync *opmansync;
	int lx, ly, lb;
	unsigned int lastkey, lastkeyticks;
};

void _GGI_aa_freedbs(ggi_visual *vis);

#endif

