/* $Id: pan.c,v 1.14 1998/10/25 01:48:00 ajapted Exp $
***************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/ioctl.h>
#include <sys/mman.h>

#include <linux/fb.h>

#include <ggi/internal/ggi-dl.h>

#include "fbdev.h"


void _GGI_fbdev_save_panning(ggi_visual *vis)
{
}

void _GGI_fbdev_restore_panning(ggi_visual *vis)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

#ifdef VESAFB_IS_NO_LONGER_BROKEN
	ioctl(LIBGGI_FD(vis), FBIOPAN_DISPLAY, &ff->orig_var); 
#endif
}


/* ---------------------------------------------------------------------- */


int GGI_fbdev_setorigin(ggi_visual *vis, int x, int y)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

	int max_x = LIBGGI_VIRTX(vis) - LIBGGI_X(vis);
	int max_y = LIBGGI_VIRTY(vis) - LIBGGI_Y(vis);

	int err=0;

	if ((x < 0) || (y < 0) || (x > max_x) || (y > max_y)) {
		DPRINT("display-fbdev: panning out of range:"
			"(%d,%d) > (%d,%d)\n", x, y, max_x, max_y);
		return -1;
	}

	ff->var.xoffset = x;
	ff->var.yoffset = y + vis->d_frame_num * LIBGGI_VIRTY(vis);

#ifdef VESAFB_IS_NO_LONGER_BROKEN
	err = ioctl(LIBGGI_FD(vis), FBIOPAN_DISPLAY, &ff->var); 
#endif
	
	if (err) {
		DPRINT("display-fbdev: PAN_DISPLAY failed.\n");
		return err;
	}

	vis->origin_x = x;
	vis->origin_y = y;
	
	return 0;
}

int GGI_fbdev_setdisplayframe(ggi_visual *vis, int num)
{
        ggi_directbuffer *db = _ggi_db_find_frame(vis, num);

        if (db == NULL) {
                return -1;
        }
        vis->d_frame_num = num;

	return GGI_fbdev_setorigin(vis, vis->origin_x, vis->origin_y);
}
