/* $Id: visual.c,v 1.32 1998/10/30 05:09:52 ajapted Exp $
***************************************************************************

   Display-FBDEV

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>

#include "fbdev.h"


int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	fbdev_hook *ff;

	DPRINT("display-fbdev: GGIdlinit start.\n");


	LIBGGI_PRIVATE(vis) = ff = _ggi_malloc(sizeof(fbdev_hook));
	
	ff->fb_ptr = NULL;
	ff->need_redraw = 0;
	ff->have_kgi = 0;
		
	LIBGGI_FD(vis) = LIBGGI_SELECT_FD(vis) = -1;

	
#ifdef OLD_CRUD_THAT_WILL_SOON_TO_BE_REMOVED
	if (getenv("GGI_FBDEV_OPTIONS") != 0) {
		if (ggParseOptions(getenv("GGI_FBDEV_OPTIONS"),
			fbdev_options, 2) == NULL) {
			
			fprintf(stderr, "display-fbdev: error in "
				"$GGI_FBDEV_OPTIONS.\n");
			free(ff);
			return GGI_DL_ERROR;
		}
	}
	
	if (args) {
		args = ggParseOptions((char *)args, fbdev_options, 2);

		if (args == NULL) {
			
			fprintf(stderr, "display-fbdev: error in "
				"arguments.\n");
			free(ff);
			return GGI_DL_ERROR;
		}
	}
#endif

	/* handle args */

	while (args && *args && isspace(*args)) args++;

	if (args && *args) {
		ff->devicetype = strdup(args);
	} else if (getenv("FRAMEBUFFER") != NULL) {
		ff->devicetype = strdup(getenv("FRAMEBUFFER"));
	} else {
		ff->devicetype = strdup("/dev/fb0");
	}
	
	/* now open the framebuffer device */

	LIBGGI_FD(vis) = open(ff->devicetype, O_RDWR);

	if (LIBGGI_FD(vis) < 0) {
		fprintf(stderr, "display-fbdev: Couldn't open "
			"framebuffer device %s: %s\n", ff->devicetype,
			strerror(errno));

		free(ff->devicetype); free(ff);
		return GGI_DL_ERROR;
	}

	/* read original mode on framebuffer */

	if ((ioctl(LIBGGI_FD(vis),FBIOGET_FSCREENINFO,&ff->orig_fix) < 0) ||
	    (ioctl(LIBGGI_FD(vis),FBIOGET_VSCREENINFO,&ff->orig_var) < 0)) {
	    
		perror("display-fbdev: GET_SCREENINFO");

		close(LIBGGI_FD(vis)); LIBGGI_FD(vis) = -1;
		free(ff->devicetype); free(ff);
		return GGI_DL_ERROR;
	}

	LIBGGI_GC(vis) = ff->normalgc = _ggi_malloc(sizeof(ggi_gc));


	/* Open keyboard input */

	vis->input = giiOpen("input-linux-kbd", NULL);

	if (vis->input == NULL) {
		fprintf(stderr, "display-fbdev: Couldn't open kbd.\n");
		close(LIBGGI_FD(vis));
		free(ff->normalgc); free(ff);
		return GGI_DL_ERROR;
	}

	
	/* Mode management */

	vis->opdisplay->getmode   = GGI_fbdev_getmode;
	vis->opdisplay->setmode   = GGI_fbdev_setmode;
	vis->opdisplay->checkmode = GGI_fbdev_checkmode;
	vis->opdisplay->getapi    = GGI_fbdev_getapi;
	vis->opdisplay->flush     = GGI_fbdev_flush;
	vis->opdisplay->setflags  = GGI_fbdev_setflags;
		
	/* Event management */
#ifdef MIGHT_ENABLE_THIS_LATER	
	vis->opdisplay->eventpoll = GGI_fbdev_eventpoll;
	vis->opdisplay->eventread = GGI_fbdev_eventread;
	vis->opdisplay->seteventmask = GGIseteventmask;
#endif

	DPRINT("display-fbdev: GGIdlinit success.\n");

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	fbdev_hook *ff = LIBGGI_PRIVATE(vis);

	DPRINT("display-fbdev: GGIdlcleanup start.\n");

	if (LIBGGI_FD(vis) >= 0) {

		GGI_fbdev_resetmode(vis);

		giiClose(vis->input);
		vis->input = NULL;

		close(LIBGGI_FD(vis));
		LIBGGI_FD(vis) = -1;
	}

	if (ff->devicetype) free(ff->devicetype);

	free(ff->normalgc);
	free(ff);

	DPRINT("display-fbdev: GGIdlcleanup done.\n");

	return 0;
}

int GGI_fbdev_flush(ggi_visual *vis, int tryflag)
{
	return 0;
}


#include <ggi/internal/ggidlinit.h>
