/* $Id: draw.c,v 1.16 1998/09/26 03:24:03 marcus Exp $
***************************************************************************

   Display-monotext: drawing operations

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include "monotext.h"


/* The following operations update the 'dirty region', which is used to
 * limit the area blit to the parent at ggiFlush() time.
 */

/* (!!! FIXME some of these are confused) */

int GGI_monotext_drawpixel_nc(ggi_visual *vis, int x, int y)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, 1);
	
	if ((err = mt->mem_opdraw->drawpixel_nc(vis, x, y)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_drawpixel(ggi_visual *vis, int x, int y)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, 1);
	
	if ((err = mt->mem_opdraw->drawpixel(vis, x, y)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_putpixel_nc(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, 1);
	
	if ((err = mt->mem_opdraw->putpixel_nc(vis, x, y, col)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_putpixel(ggi_visual *vis, int x, int y, ggi_pixel col)
{ 
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, 1);
	
	if ((err = mt->mem_opdraw->putpixel(vis, x, y, col)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_drawline(ggi_visual *vis, int x1, int y1, int x2, int y2)
{ 
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;

	int sx = MIN(x1, x2);
	int sy = MIN(y1, y2);

	int ex = MAX(x1, x2);
	int ey = MAX(y1, y2);

	UPDATE_MOD(mt, sx, sy, ex-sx, ey-sy);

	if ((err = mt->mem_opdraw->drawline(vis, x1, y1, x2, y2)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_drawhline_nc(ggi_visual *vis, int x, int y, int w)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	err = mt->mem_opdraw->drawhline_nc(vis, x, y, w);

	if (! err) {
		_ggi_monotextUpdate(vis, x, y, w, 1);
	}

	UPDATE_SYNC;
	return err;
}

int GGI_monotext_drawhline(ggi_visual *vis, int x, int y, int w)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	err = mt->mem_opdraw->drawhline(vis, x, y, w);

	if (! err) {
		_ggi_monotextUpdate(vis, x, y, w, 1);
	}

	UPDATE_SYNC;
	return err;
}

int GGI_monotext_puthline(ggi_visual *vis, int x, int y, int w, void *buffer)
{ 
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	err = mt->mem_opdraw->puthline(vis, x, y, w, buffer);
	
	if (! err) {
		_ggi_monotextUpdate(vis, x, y, w, 1);
	}

	UPDATE_SYNC;
	return err;
}

int GGI_monotext_drawvline_nc(ggi_visual *vis, int x, int y, int h)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, h);
	
	if ((err = mt->mem_opdraw->drawvline_nc(vis, x, y, h)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_drawvline(ggi_visual *vis, int x, int y, int h)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, h);
	
	if ((err = mt->mem_opdraw->drawvline(vis, x, y, h)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}

int GGI_monotext_putvline(ggi_visual *vis, int x, int y, int h, void *buffer)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	UPDATE_MOD(mt, x, y, 1, h);
	
	if ((err = mt->mem_opdraw->putvline(vis, x, y, h, buffer)) < 0) {
		return err;
	}

	UPDATE_SYNC;
	return 0;
}


/* ---------------------------------------------------------------------- */


/* The following operations DON'T update the 'dirty region', instead
 * they simply perform the blit to the parent.  Note: it is assumed that
 * the affected area is relatively large. 
 */
 
int GGI_monotext_putbox(ggi_visual *vis, int x, int y, int w, int h, void *buffer)
{ 
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	if ((err = mt->mem_opdraw->putbox(vis, x, y, w, h, buffer)) < 0) {
		return err;
	}

	return _ggi_monotextUpdate(vis, x, y, w, h);
}

int GGI_monotext_drawbox(ggi_visual *vis, int x, int y, int w, int h)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	if ((err = mt->mem_opdraw->drawbox(vis, x, y, w, h)) < 0) {
		return err;
	}

	return _ggi_monotextUpdate(vis, x, y, w, h);
}

int GGI_monotext_copybox(ggi_visual *vis, int x, int y, int w, int h, int nx, int ny)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	if ((err = mt->mem_opdraw->copybox(vis, x, y, w, h, nx, ny)) < 0) {
		return err;
	}

	return _ggi_monotextUpdate(vis, nx, ny, w, h);
}

int GGI_monotext_crossblit(ggi_visual *src, int sx, int sy, int w, int h,
                 ggi_visual *vis, int dx, int dy)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	if ((err = mt->mem_opdraw->crossblit(src, sx, sy, w, h, 
					   vis, dx, dy)) < 0) {
		return err;
	}

	return _ggi_monotextUpdate(vis, dx, dy, w, h);
}

int GGI_monotext_fillscreen(ggi_visual *vis)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);
	int err;
	
	if ((err = mt->mem_opdraw->fillscreen(vis)) < 0) {
		return err;
	}

	return _ggi_monotextUpdate(vis, 0, 0,
		LIBGGI_MODE(vis)->virt.x, LIBGGI_MODE(vis)->virt.y);
}


/* ---------------------------------------------------------------------- */


/* The following functions are just pass-throughs to the parent visual.
 */

int GGI_monotext_setorigin(ggi_visual *vis, int x, int y)
{
	MonotextHook *mt = LIBGGI_PRIVATE(vis);

	int err;
	
	if ((err = ggiSetOrigin(mt->parent, x, y)) != 0)
		return err;

	vis->origin_x=x;
	vis->origin_y=y;
	
	return 0;
}
