/* $Id: color.c,v 1.10 1998/10/04 07:29:18 ajapted Exp $
***************************************************************************

   Display-palemu: color

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "palemu.h"


int GGI_palemu_setpalvec(ggi_visual *vis, int start, int len, ggi_color *colormap)
{
	PalemuHook *ph = PALEMU_PRIV(vis);

	DPRINT("display-palemu: SetPalVec(%d,%d)\n", start, len);
	
	if (start == GGI_PALETTE_DONTCARE) {
		start = 0;
	}

	if ((start < 0) || (len < 0) || (start+len > 256)) {
		return -1;
	}

	memcpy(vis->palette+start, colormap, len*sizeof(ggi_color));

	if (len > 0) {
		UPDATE_MOD(vis, 0, 0, LIBGGI_VIRTX(vis), LIBGGI_VIRTY(vis));
	}

	for (; len > 0; len--, start++, colormap++) {

		ph->palette[start] = *colormap;
		ph->lookup[start] = ggiMapColor(ph->parent, colormap);
	}
	
	return 0;
}
