/* $Id: text.c,v 1.7 1998/10/10 13:24:18 ajapted Exp $
***************************************************************************

   Display-palemu: text

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>

#include <ggi/internal/ggi-dl.h>

#include "palemu.h"

#undef putc


int GGI_palemu_putc(ggi_visual *vis, int x, int y, char c)
{
	PalemuHook *ph = PALEMU_PRIV(vis);

	int char_w;
	int char_h;
	
	ggiGetCharSize(vis, &char_w, &char_h);

	UPDATE_MOD(vis, x, y, char_w, char_h);
	
	return ph->mem_opdraw->putc(vis, x, y, c);
}

#if 0
int GGI_palemu_getcharsize(ggi_visual *vis, int *width, int *height)
{
	PalemuHook *ph = LIBGGI_PRIVATE(vis);

	return ggiGetCharSize(ph->parent, width, height);
}
#endif
