/* $Id: visual.c,v 1.16 1998/10/24 04:03:48 marcus Exp $
***************************************************************************

   Display-palemu: initialization

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "palemu.h"

static gg_option palemu_options[1] =
{
	{ "parent", "[C]" }
};


int GGIdlinit(ggi_visual *vis, const char *args,void *argptr)
{
	PalemuHook *ph;

	char target[1024];


	/* initialize */

	DPRINT("display-palemu: GGIdlinit start.\n");

	LIBGGI_FD(vis) = -1;

	LIBGGI_PRIVATE(vis) = ph = _ggi_malloc(sizeof(PalemuHook));

	vis->gc = _ggi_malloc(sizeof(ggi_gc));
	ph->opmansync = _ggi_malloc(sizeof(_ggi_opmansync));

	_ggiLockInit(ph->flush_lock);

	ph->flags  = 0;
	ph->fb_ptr = NULL;


	/* handle arguments */

	if (getenv("GGI_PALEMU_OPTIONS") != NULL) {
		if (ggParseOptions(getenv("GGI_PALEMU_OPTIONS"),
			palemu_options, 1) == NULL) {
			
			fprintf(stderr, "display-palemu: error in "
				"$GGI_PALEMU_OPTIONS.\n");
			free(ph);
			return GGI_DL_ERROR;
		}
	}
	
	if (args) {
		args = ggParseOptions((char *) args, palemu_options, 3);
			
		if (args == NULL) {
			fprintf(stderr, "display-palemu: error in "
				"arguments.\n");
			free(ph);
			return GGI_DL_ERROR;
		}
	}

	DPRINT("display-palemu: parent mode is '%s'\n",
		palemu_options[0].result);

	ggiParseMode(palemu_options[0].result, &ph->mode);
	

	/* setup mansync */

	if (! _ggiAddDL(vis, "helper-mansync", (char *) ph->opmansync, NULL, 0)) {
		fprintf(stderr, "display-palemu: Cannot load "
			"helper-mansync!\n");
		return GGI_DL_ERROR;
	}

	MANSYNC_init(vis);


	/* open the parent visual */

	while (args && *args && isspace((unsigned char) *args)) {
		args++;
	}

	DPRINT("display-palemu: opening target: %s\n", args);

	strcpy(target, "");

	if (args) {
		if (ggParseTarget((char *) args, target, 1024) == NULL) {
			/* error occurred */
			free(ph);
			return GGI_DL_ERROR;
		}
	}

	if (*target == 0) {
		ph->parent = ggiOpen(NULL);
	} else {
		ph->parent = ggiOpen(target, NULL);
	}

	if (ph->parent == NULL) {
		fprintf(stderr, "display-palemu: Failed to open "
			"target: '%s'\n", target);
		free(ph);
		return GGI_DL_ERROR;
	}
	
	ggiSetFlags(ph->parent, GGIFLAG_ASYNC);

	/* Add giiInputs, if we have them. */
	if (ph->parent->input)
	{
		vis->input=giiJoinInputs(vis->input,ph->parent->input);
		ph->parent->input=NULL;	/* Destroy old reference */
	}

	/* Has mode management */
	
	vis->opdisplay->getmode = GGI_palemu_getmode;
	vis->opdisplay->setmode = GGI_palemu_setmode;
	vis->opdisplay->checkmode = GGI_palemu_checkmode;
	vis->opdisplay->getapi = GGI_palemu_getapi;
	vis->opdisplay->flush = GGI_palemu_flush;
	vis->opdisplay->setflags = GGI_palemu_setflags;
	
	vis->opdisplay->eventpoll = GGI_palemu_eventpoll;
	vis->opdisplay->eventread = GGI_palemu_eventread;
	vis->opdisplay->seteventmask = GGIseteventmask;
	
	DPRINT("display-palemu: GGIdlinit succeeded.\n");

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	PalemuHook *ph = PALEMU_PRIV(vis);

	DPRINT("display-palemu: GGIdlcleanup start.\n");

	MANSYNC_deinit(vis);

	if (ph->fb_ptr != NULL) {
		GGI_palemu_resetmode(vis);
	}

	if (ph->parent != NULL) {
		ggiClose(ph->parent);
		ph->parent = NULL;
	}

	LIBGGI_PRIVATE(vis) = NULL;

	_ggiLockDestroy(ph->flush_lock);

	free(ph->opmansync);
	free(vis->gc);
	free(ph);

	DPRINT("display-palemu: GGIdlcleanup done.\n");

	return 0;
}

#include <ggi/internal/ggidlinit.h>
