/* $Id: visual.c,v 1.16 1998/10/18 15:52:58 becka Exp $
***************************************************************************

   Display-sub

   Copyright (C) 1998 Andreas Beck    [becka@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdlib.h>
#include <string.h>

#include <ggi/internal/ggi-dl.h>
#include "SubVisual.h"

int GGIdlinit(ggi_visual *vis,const char *args,void *argptr)
{
	SubHook *subinfo;

	LIBGGI_FD(vis)=-1;

	if (! argptr) {

		fprintf(stderr,"display-sub needs pointer to real visual as argument.\n");
		return -1;
	}

	LIBGGI_PRIVATE(vis)=subinfo=_ggi_malloc(sizeof(SubHook));
	LIBGGI_GC(vis)=_ggi_malloc(sizeof(ggi_gc));

	subinfo->parent=argptr;

	subinfo->position.x=subinfo->position.y=0;
	subinfo->botright.x=subinfo->botright.y=0;

	/* Has mode management */
	vis->opdisplay->getmode=GGI_sub_getmode;
	vis->opdisplay->setmode=GGI_sub_setmode;
	vis->opdisplay->checkmode=GGI_sub_checkmode;
	vis->opdisplay->flush=GGI_sub_flush;
	vis->opdisplay->getapi=GGI_sub_getapi;
	vis->opdisplay->setflags=GGI_sub_setflags;

	vis->opdisplay->eventpoll=GGI_sub_eventpoll;
	vis->opdisplay->eventread=GGI_sub_eventread;

	vis->opdraw->fillscreen=GGI_sub_fillscreen;

	vis->opdraw->setorigin=GGI_sub_setorigin;

	vis->opdraw->putc=GGI_sub_putc;
	vis->opdraw->puts=GGI_sub_puts;

	vis->opdraw->drawpixel_nc=GGI_sub_drawpixel;
	vis->opdraw->drawpixel=GGI_sub_drawpixel;
	vis->opdraw->putpixel_nc=GGI_sub_putpixel;
	vis->opdraw->putpixel=GGI_sub_putpixel;
	vis->opdraw->getpixel=GGI_sub_getpixel;

	vis->opdraw->drawhline=GGI_sub_drawhline;
	vis->opdraw->puthline=GGI_sub_puthline;
	vis->opdraw->gethline=GGI_sub_gethline;

	vis->opdraw->drawvline=GGI_sub_drawvline;
	vis->opdraw->putvline=GGI_sub_putvline;
	vis->opdraw->getvline=GGI_sub_getvline;

	vis->opdraw->drawbox=GGI_sub_drawbox;
	vis->opdraw->putbox=GGI_sub_putbox;
	vis->opdraw->getbox=GGI_sub_getbox;

	vis->opdraw->drawline=GGI_sub_drawline;
	vis->opdraw->copybox=GGI_sub_copybox;

	vis->opdraw->crossblit=GGI_sub_crossblit;

	vis->opcolor->getgamma=GGI_sub_getgamma;
	vis->opcolor->setgamma=GGI_sub_setgamma;
	vis->opcolor->getgammamap=GGI_sub_getgammamap;
	vis->opcolor->setgammamap=GGI_sub_setgammamap;

	vis->opcolor->mapcolor=GGI_sub_mapcolor;
	vis->opcolor->unmappixel=GGI_sub_unmappixel;
	vis->opcolor->setpalvec=GGI_sub_setpalvec;
	vis->opcolor->getpalvec=GGI_sub_getpalvec;

	return GGI_DL_OPDISPLAY;
}

int GGIdlcleanup(ggi_visual *vis)
{
	free(LIBGGI_PRIVATE(vis));
	free(LIBGGI_GC(vis));

	return 0;
}

#include <ggi/internal/ggidlinit.h>
