/* $Id: mode.c,v 1.9 1998/09/20 21:24:43 marcus Exp $
***************************************************************************

   Display-SUID

   Copyright (C) 1998 Andrew Apted    [andrew@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <dlfcn.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include <ggi/internal/ggi-dl.h>
#include <ggi/internal/internal.h>
#include "debug.h"

int graph_ioctl( unsigned int cmd,...);
extern int _suidtarget_dev_mem;

extern int suid_kbd_fd;
extern int suid_mouse_fd;

int GGIkgicommand(ggi_visual *vis,int cmd,void *args)
{
	return graph_ioctl(cmd,args);
}

int GGIsetorigin(ggi_visual *vis,int x,int y)
{
	ggi_coord where;

	int err;

	CHECKXY(vis,x,y);

	where.x=x;
	where.y=y;

	DPRINT("GGIsetorigin:\n");

	if ((err=GGIkgicommand(vis,CHIP_SETVISFRAME,&where) != 0)
		return err;

	vis->origin_x=x;
	vis->origin_y=y;
	
	return 0;
}

int GGIsetsplitline(ggi_visual *vis,int y)
{
	if (y<0 || y>LIBGGI_MODE(vis)->visible.y) return -1;

	DPRINT("GGIsetsplitline:\n");
	return GGIkgicommand(vis,CHIP_SETSPLITLINE,y);
}

void get_primary_fb(long *sz,long *psz,long *pstart);

/*
 * _Attempt_ to get the default framebuffer.. 
 */
static void _GGIgetmmio(ggi_visual *vis)
{
	long regsize,regpsize,regpstart;
	int size=LIBGGI_MODE(vis)->virt.x*LIBGGI_MODE(vis)->virt.y;

	if (LIBGGI_FB_LINEAR(vis)!=NULL) {
		munmap(LIBGGI_FB_LINEAR(vis),LIBGGI_FB_LINEAR_SIZE(vis));
		LIBGGI_FB_LINEAR(vis)=NULL;
		LIBGGI_FB_LINEAR_SIZE(vis)=0;
	}

	size=_ggiSetupMode(vis);
	DPRINT("Calculated size=%d bytes\n",size);

	if (size <= 0) 
		return;

	LIBGGI_FB_LINEAR_SIZE(vis)=size;	

	/* Now we map the FB ... */
	get_primary_fb(&regsize,&regpsize,&regpstart);
	
	if (regpsize!=regsize)
		DPRINT("Banked framebuffer (%x!=%x) - not implemented !\n",
		       regpsize,regsize);

	if (size>regsize)
		DPRINT("Total framebuffer too small ??? (%x>%x)"
		       "Will probably fail.\n",
		       size,regsize);

	if (size>regpsize) {
		DPRINT("Single bank too small. (%x>%x)"
		       "Cutting down - will probably fail.\n",
		       size,regpsize);
		size=regpsize;
	}
	
	/* FIXME !! */
	LIBGGI_FB_LINEAR(vis)=mmap(NULL,
                     size,
                     PROT_READ|PROT_WRITE,
                     MAP_SHARED,
                     _suidtarget_dev_mem,
	             regpstart);
//	             MMAP_TYPE_MMIO|MMAP_PER_REGION_TYPE|MMAP_FRAMEBUFFER);

	DPRINT("Linear FB=%p\n",LIBGGI_FB_LINEAR(vis));
	if (LIBGGI_FB_LINEAR(vis) == (void *)(-1)) {
		LIBGGI_FB_LINEAR(vis)=NULL;
		LIBGGI_FB_LINEAR_SIZE(vis)=0;
	}
}

static int _GGIdomode(ggi_visual *vis)
{
	int err;
	ggi_suggest sug;

	_GGIgetmmio(vis);

	err=(_ggiOpenDL(vis,"generic-stubs","")==NULL);
	if (err) {
		fprintf(stderr,"display-suidkgi: Can't load the \"generic-stubs\" "
			       "library\n");
	}
		
	vis->opdraw->setsplitline=GGIsetsplitline;
	vis->opdraw->setorigin=GGIsetorigin;

	sug.id=0;
	do {
		err=GGIkgicommand(vis,GRAPHICS_GETSUGGEST,&sug);
		if (err!=0) {
			fprintf(stderr,"display-suidkgi: Failed getting suggestion %d err=%x\n",
				       sug.id,err);
			return -1;	/* Error */
		}

		DPRINT("display-suid - attempting %s (%s)\n",sug.name,sug.args);
		err=(_ggiOpenDL(vis,sug.name,sug.args)==NULL);
		if (err) {
			fprintf(stderr,"display-suidkgi: Can't find an appropriate "
				       "library for %s (%s)\n",
					sug.name,sug.args);
			/* return err; */
		} else {
			DPRINT("Success in loading %s (%s)\n",sug.name,sug.args);
		}
	} while (sug.id!=0);

	return 0;
}

int GGIsetmode(ggi_visual *vis,ggi_mode *tm)
{ 
	int err;

	if (vis==NULL) {
		DPRINT("Visual==NULL\n");
		return -1;
	}
	
	/* Temporary */
	if (LIBGGI_FB_LINEAR(vis)!=NULL) {	/* Unmap mem - it might be invalid after mode-change */
		munmap(LIBGGI_FB_LINEAR(vis),LIBGGI_FB_LINEAR_SIZE(vis));
		LIBGGI_FB_LINEAR(vis)=NULL;
	}
	_ggiZapMode(vis,~GGI_DL_OPDISPLAY);


	/* Setup new VT 
	*/
	suid_kbd_fd = vtswitch_open(vis); if (suid_kbd_fd < 0) {
		return -1;
	}

	DPRINT("DRIVER_SETGRAPHMODE:\n");
	err=GGIkgicommand(vis,DRIVER_SETGRAPHMODE,tm);
	if (err) {
		DPRINT("%d=GGIkgicommand(vis,DRIVER_SETGRAPHMODE,%p)\n",err,tm);
		return err;
	}
	memcpy(LIBGGI_MODE(vis),tm,sizeof(ggi_mode));


	/* Setup input devices 
	*/
	fbdev_init_keyboard(vis, suid_kbd_fd);
	suid_mouse_fd = fbdev_init_mouse(vis, NULL);


	return _GGIdomode(vis);
}

/**********************************/
/* check any mode (text/graphics) */
/**********************************/
int GGIcheckmode(ggi_visual *vis,ggi_mode *tm)
{
	if (vis==NULL)
		return -1;
	
	DPRINT("DRIVER_TESTMODE:\n");
	return GGIkgicommand(vis,DRIVER_TESTMODE,tm);
}

/************************/
/* get the current mode */
/************************/
int GGIgetmode(ggi_visual *vis,ggi_mode *tm)
{
	DPRINT("In GGIgetmode(%p,%p)\n",vis,tm);
	if (vis==NULL)
		return -1;
	
	DPRINT("DRIVER_GETGRAPHMODE:\n");
	return GGIkgicommand(vis,DRIVER_GETGRAPHMODE,tm);
}

/*************************/
/* set the current flags */
/*************************/
int GGIsetflags(ggi_visual *vis,ggi_flags flags)
{
	LIBGGI_FLAGS(vis)=flags;
	return 0;
}


void handle_switched_away(ggi_visual *vis)
{
	/* Reset the graphic card into text mode, ready for console
	 * switching.  VT switching remains disabled during this
	 * routine.
	 */

#if 1
	raise(11 /*SIGSEGV*/);
#else
	!!! implement me
#endif
}


void handle_switched_back(ggi_visual *vis)
{
	/* Restore the graphic card to the mode it was in before
	 * switched away.  VT switching remains disabled during this
	 * routine.
	 */

#if 1
	raise(11 /*SIGSEGV*/);
#else
	!!! implement me
#endif
}
