/* $Id: vgavisual.h,v 1.9 1998/09/23 21:35:27 marcus Exp $
***************************************************************************

   LibGGI SVGAlib target

   Copyright (C) 1998 Marcus Sundberg   [marcus@ggi-project.org]
   Copyright (C) 1998 Steve Cheng       [steve@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ----------------------------------------------------------------------
   README:

   Programs need SUID root. You really should use KGI :-)

   Uses raw keyboard mode! That means "a crash might render the console
   unusable. (but shouldn't)." Of course, SVGAlib is inherently dangerous,
   so this is nothing new.
   
   When using the SVGAlib target, LibGGI programs will always segfault at
   the end. This happens because SVGAlib likes to attach itself to the end
   of programs to do some 'cleanup'. The problem is, SVGAlib would be
   unloaded along with the target by ggiClose(), and hence it won't be there
   at the end of the program (cannot access memory). However, this behavior
   normally shouldn't cause any problems.

   This behaviour is avoided by doing a signal(SIGSEGV,_exit) in
   ggiClose(). This is only done if LIBGGI_DEBUG is != 0.
   To completely disable this, define ALWAYS_SEGFAULT_ON_EXIT below.
   
   Likewise, SVGAlib will also install its own signal handlers, so beware.
   
   See source for miscellaneous stuff. 
   The SVGAlib target now supports banked and modeX modes.

***************************************************************************
*/

/*
 * ------------------------------------------------------------------------
 * Things you might want to change.
 * ------------------------------------------------------------------------
 */ 

/* The sample rate of your mouse.
   Most people need not change this. */

#define SAMPLE_RATE MOUSE_DEFAULTSAMPLERATE

/* Never prevent apps from segfaulting on exit */
/*
#define ALWAYS_SEGFAULT_ON_EXIT
*/

/*
 * ------------------------------------------------------------------------
 * Do not change anything below this line.
 * ------------------------------------------------------------------------
 */ 

#include <vga.h>
#include <vgakeyboard.h>
#include <vgamouse.h>

#include <ggi/internal/ggi-dl.h>
#include "../common/modelist.h"

ggifunc_flush		GGI_svga_flush;
ggifunc_getmode		GGI_svga_getmode;
ggifunc_setmode		GGI_svga_setmode;
ggifunc_getapi		GGI_svga_getapi;
ggifunc_checkmode	GGI_svga_checkmode;
ggifunc_setflags	GGI_svga_setflags;

ggifunc_eventpoll	GGI_svga_eventpoll;
ggifunc_eventread	GGI_svga_eventread;
ggifunc_seteventmask	GGIseteventmask;

ggifunc_putpixel	GGI_svga_putpixel;
ggifunc_putpixel	GGI_svga_putpixel_nc;
ggifunc_getpixel	GGI_svga_getpixel;
ggifunc_drawpixel	GGI_svga_drawpixel;
ggifunc_drawpixel	GGI_svga_drawpixel_nc;
ggifunc_drawhline	GGI_svga_drawhline;
ggifunc_drawhline	GGI_svga_drawhline_nc;
ggifunc_drawvline	GGI_svga_drawvline;
ggifunc_drawvline	GGI_svga_drawvline_nc;
ggifunc_drawbox		GGI_svga_drawbox;
ggifunc_puthline	GGI_svga_puthline;
ggifunc_gethline	GGI_svga_gethline;
ggifunc_putbox		GGI_svga_putbox;

ggifunc_setpalvec	GGI_svga_setpalvec;

struct svga_priv {
	ggi_modelistmode  *availmodes;
	char               islinear;
	char               ismodex;
	char               isbanked;
};

#define SVGA_PRIV(vis) ((struct svga_priv*)LIBGGI_PRIVATE(vis))

void _GGIkeyboardhandler(int scancode, int press);
void _GGImousehandler(int button, int dx, int dy, int dz, int drx, int dry, int drz);
