/* $Id: events.c,v 1.15 1998/10/26 04:11:12 ajapted Exp $
***************************************************************************

   Terminfo target

   Copyright (C) 1997 Jason McMullan    [jmcc@ggi-project.org]
   Copyright (C) 1998 MenTaLboY         [mentalboy@geocities.com]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>

#include "TIvisual.h"

#include <ggi/internal/ggi-dl.h>
#define WANT__NewEvent
#include "../common/evqueue.inc"

static int translate_key(int key, uint16 *modifiers)
{
	DPRINT("terminfo: TRANSLATEKEY %04x\n", key);

	*modifiers = 0;

	if ((0x00 <= key) && (key <= 0x7f)) {
		return key;
	}

	if ((KEY_F0+1 <= key) && (key <= KEY_F0+20)) {
		return GII_KEY(GII_KT_FN, key-1);
	}
	
	if ((KEY_F0+21 <= key) && (key <= KEY_F0+63)) {
		return GII_KEY(GII_KT_FN, key+9);
	}
	
	switch (key) {

		case '\015':		return GIIK_Enter;

		case KEY_BREAK:		return GIIK_Break;
		case KEY_DOWN:		return GIIK_Down;
		case KEY_UP:		return GIIK_Up;
		case KEY_LEFT:		return GIIK_Left;
		case KEY_RIGHT:		return GIIK_Right;
		case KEY_BACKSPACE:	return 8;

		case KEY_DC:		return GIIK_Remove;
		case KEY_IC:		return GIIK_Insert;
		case KEY_EIC:		return GIIK_Insert;  /* ??? */
		case KEY_SF:		return GIIK_ScrollForw;
		case KEY_SR:		return GIIK_ScrollBack;
		case KEY_NPAGE:		return GIIK_PageDown;
		case KEY_PPAGE:		return GIIK_PageUp;
		case KEY_ENTER:		return GIIK_Enter;
		case KEY_SRESET:	return GIIK_SAK;   /* ??? */
		case KEY_RESET:		return GIIK_Boot;  /* ??? */
		case KEY_A1:		return GIIK_Home;
		case KEY_A3:		return GIIK_PageUp;
		case KEY_C1:		return GIIK_End;
		case KEY_C3:		return GIIK_PageDown;

		case KEY_END:		return GIIK_End;
		case KEY_FIND:		return GIIK_Find;
		case KEY_HELP:		return GIIK_Help;
		case KEY_UNDO:		return GIIK_Undo;
		case KEY_NEXT:		return GIIK_Next;
		case KEY_PREVIOUS:	return GIIK_Prior;
		case KEY_SELECT:	return GIIK_Select;
		case KEY_SUSPEND:	return GIIK_Pause;  /* ??? */

		/*** NOT DONE :

		case KEY_HOME           Home key (upward+left arrow)
		case KEY_DL             Delete line
		case KEY_IL             Insert line
		case KEY_CLEAR:		Clear
		case KEY_EOS:		Clear to end of screen
		case KEY_EOL:		Clear to end of line
		case KEY_STAB:		Set tab
		case KEY_CTAB:		Clear tab
		case KEY_CATAB:		Clear all tabs
		case KEY_PRINT:		Print or copy
		case KEY_LL:		Home down or bottom (lower left).
		case KEY_B2:		Centre of keypad

		case KEY_BTAB:		Back tab key
		case KEY_BEG:		Beg(inning) key
		case KEY_CANCEL		Cancel key
		case KEY_CLOSE:		Close key
		case KEY_COMMAND:	Cmd (command) key
		case KEY_COPY:		Copy key
		case KEY_CREATE:	Create key
		case KEY_EXIT:		Exit key
		case KEY_MARK:		Mark key
		case KEY_MESSAGE:	Message key
		case KEY_MOVE:		Move key
		case KEY_OPEN:		Open key
		case KEY_OPTIONS:	Options key
		case KEY_REDO:		Redo key
		case KEY_REFERENCE:	Ref(erence) key
		case KEY_REFRESH:	Refresh key
		case KEY_REPLACE:	Replace key
		case KEY_RESTART:	Restart key
		case KEY_RESUME:	Resume key
		case KEY_SAVE:		Save key

		case KEY_SBEG:		Shifted beginning key
		case KEY_SCANCEL:	Shifted cancel key
		case KEY_SCOMMAND:	Shifted command key
		case KEY_SCOPY:		Shifted copy key
		case KEY_SCREATE:	Shifted create key
		case KEY_SDC:		Shifted delete char key
		case KEY_SDL:		Shifted delete line key
		case KEY_SEND:		Shifted end key
		case KEY_SEOL:		Shifted clear line key
		case KEY_SEXIT:		Shifted exit key
		case KEY_SFIND:		Shifted find key
		case KEY_SHELP:		Shifted help key
		case KEY_SHOME:		Shifted home key
		case KEY_SIC:		Shifted input key
		case KEY_SLEFT:		Shifted left arrow key
		case KEY_SMESSAGE:	Shifted message key
		case KEY_SMOVE:		Shifted move key
		case KEY_SNEXT:		Shifted next key
		case KEY_SOPTIONS:	Shifted options key
		case KEY_SPREVIOUS:	Shifted prev key
		case KEY_SPRINT:	Shifted print key
		case KEY_SREDO:		Shifted redo key
		case KEY_SREPLACE:	Shifted replace key
		case KEY_SRIGHT:	Shifted right arrow
		case KEY_SRSUME:	Shifted resume key
		case KEY_SSAVE:		Shifted save key
		case KEY_SSUSPEND:	Shifted suspend key
		case KEY_SUNDO:		Shifted undo key

		***/
	}

	return GIIK_VOID;   /* unknown */
}

static int _ggiGetAndQueueEvents(ggi_visual_t vis)
{
	ggi_event ev;
	int key, status;
	struct TIhooks *tiinfo;

	status = 0;

	tiinfo = (struct TIhooks *)LIBGGI_PRIVATE(vis);

	lock_ncurses();
	set_term(tiinfo->scr);
	key = wgetch(stdscr);
	switch (key) {
		case ERR: {
			status = -1;
		} break;
#if ( NCURSES_MOUSE_VERSION == 1 )		
		case KEY_MOUSE: {
			ggi_mode *mode;
			MEVENT mev;

			mode = LIBGGI_MODE(vis);

			getmouse(&mev);
			__NewEvent(&ev);

			switch (mev.bstate) {
				case BUTTON1_PRESSED:
				case BUTTON2_PRESSED:
				case BUTTON3_PRESSED:
				case BUTTON4_PRESSED: {
					ev.any.type = evPtrButtonPress;
					ev.any.size = sizeof(ggi_pbutton_event);
					switch (mev.bstate) {
						case BUTTON1_PRESSED: ev.pbutton.button = 1;
						case BUTTON2_PRESSED: ev.pbutton.button = 4;
						case BUTTON3_PRESSED: ev.pbutton.button = 2;
						case BUTTON4_PRESSED: ev.pbutton.button = 8;
					}
					ev.pbutton.state = 1;
				} break;
				case BUTTON1_RELEASED:
				case BUTTON2_RELEASED:
				case BUTTON3_RELEASED:
				case BUTTON4_RELEASED: {
					ev.any.type = evPtrButtonRelease;
					ev.any.size = sizeof(ggi_pbutton_event);
					switch (mev.bstate) {
						case BUTTON1_RELEASED: ev.pbutton.button = 1;
						case BUTTON2_RELEASED: ev.pbutton.button = 4;
						case BUTTON3_RELEASED: ev.pbutton.button = 2;
						case BUTTON4_RELEASED: ev.pbutton.button = 8;
					}
					ev.pbutton.state = 0;
				} break;
				default: {
					ev.any.type = evPtrAbsolute;
					ev.any.size = sizeof(ggi_pmove_event);
					ev.pmove.x = mev.x * mode->dpp.x;
					ev.pmove.y = mev.y * mode->dpp.y;
				}
			}
			_ggiEvQueueAdd(vis, &ev);
			status = 1;
		} break;
#endif /* NCURSES_MOUSE_VERSION */
		case '\033': {
			timeout(1);
			key = wgetch(stdscr);
			timeout(0);
			if ( key != ERR ) {
				__NewEvent(&ev);
				ev.any.size = sizeof(ggi_key_event);
				ev.any.type = evKeyPress;
				ev.key.effect = 1 << GII_KM_ALT;
				ev.key.sym = translate_key(key, &ev.key.effect);
				ev.key.label = ev.key.sym;  /* !!! FIXME */
				ev.key.button = key;
				_ggiEvQueueAdd(vis, &ev);

				__NewEvent(&ev);
				ev.any.size = sizeof(ggi_key_event);
				ev.any.type = evKeyRelease;
				ev.key.effect = 1 << GII_KM_ALT;
				ev.key.sym = translate_key(key, &ev.key.effect);
				ev.key.label = ev.key.sym;  /* !!! FIXME */
				ev.key.button = key;
				_ggiEvQueueAdd(vis, &ev);
				status = 2;
				break;
			}
		} 
		default: {
			__NewEvent(&ev);
			ev.any.size = sizeof(ggi_key_event);
			ev.any.type = evKeyPress;
			ev.key.effect = 0;
			ev.key.sym = translate_key(key, &ev.key.effect);
			ev.key.label = ev.key.sym;  /* !!! FIXME */
			ev.key.button = key;
			_ggiEvQueueAdd(vis, &ev);

			__NewEvent(&ev);
			ev.any.size = sizeof(ggi_key_event);
			ev.any.type = evKeyRelease;
			ev.key.effect = 0;
			ev.key.sym = translate_key(key, &ev.key.effect);
			ev.key.label = ev.key.sym;  /* !!! FIXME */
			ev.key.button = key;
			_ggiEvQueueAdd(vis, &ev);
			status = 2;
		}
	}
	unlock_ncurses();
	
	return status;
}

/************************** GGI Functions ***************************/
/* Event Handling */
ggi_event_mask GGI_terminfo_eventpoll(ggi_visual_t vis, ggi_event_mask mask,
			    struct timeval *t)
{
	fd_set fds;
	int err, fd;
	ggi_event_mask evmask;

if (t==NULL) {
	DPRINT("GGI_terminfo_eventpoll(%p,0x%.8x,NULL)\n",vis,mask);
} else {
	DPRINT("GGI_terminfo_eventpoll(%p,0x%.8x,{%d,%d})\n",vis,mask,t->tv_sec,t->tv_usec);
}

	evmask = _ggiEvQueueSeen(vis, mask);
	if ( evmask != 0 )  
		return evmask;

	fd = fileno(( (struct TIhooks *)LIBGGI_PRIVATE(vis) )->f_in);

	do {
		if ( _ggiGetAndQueueEvents(vis) <= 0 ) {
			FD_ZERO(&fds);
			FD_SET(fd, &fds);

			err = select(fd+1, &fds, NULL, NULL, t);
			if ( err < 0 ) 
				return 0;
			if (FD_ISSET(fd, &fds)) {
				if ( _ggiGetAndQueueEvents(vis) > 0 ) {
					evmask = _ggiEvQueueSeen(vis, mask);
				}
			}
		} else {
			evmask = _ggiEvQueueSeen(vis, mask);
		}
	} while ( evmask == 0 && t == NULL );

	return evmask;
}

int GGI_terminfo_eventread(ggi_visual_t vis, ggi_event *ev, ggi_event_mask mask)
{
	/* Block if we don't have anything queued... */
	GGI_terminfo_eventpoll(vis, mask, NULL);
	return _ggiEvQueueRelease(vis, ev, mask);
}
