/* $Id: gc.c,v 1.8 1998/09/20 21:21:56 marcus Exp $
***************************************************************************

   Graphics library for GGI. GC handling

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
 
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <ggi/internal/internal.h>

int ggiSetGCForeground(ggi_visual *vis,ggi_pixel color)
{
	LIBGGI_GC(vis)->fg_color=color;
	LIBGGI_GC(vis)->version++;

	if (vis->opgc->gcchanged != NULL)
		vis->opgc->gcchanged(vis, GGI_GCCHANGED_FG);

	return 0;
}

int ggiSetGCBackground(ggi_visual *vis,ggi_pixel color)
{
	LIBGGI_GC(vis)->bg_color=color;
	LIBGGI_GC(vis)->version++;

	if (vis->opgc->gcchanged != NULL)
		vis->opgc->gcchanged(vis, GGI_GCCHANGED_BG);

	return 0;
}

int ggiGetGCForeground(ggi_visual *vis,ggi_pixel *color)
{
	*color=LIBGGI_GC(vis)->fg_color;
	return 0;
}

int ggiGetGCBackground(ggi_visual *vis,ggi_pixel *color)
{
	*color=LIBGGI_GC(vis)->bg_color;
	return 0;
}

int ggiSetGCClipping(ggi_visual_t vis,int left,int top,int right,int bottom)
{
	if ((left < 0) || (top < 0) || 
	    (right  > LIBGGI_MODE(vis)->virt.x) || 
	    (bottom > LIBGGI_MODE(vis)->virt.y)) {
		return -1;
	}

	LIBGGI_GC(vis)->cliptl.x = left;
	LIBGGI_GC(vis)->cliptl.y = top;
	LIBGGI_GC(vis)->clipbr.x = right;
	LIBGGI_GC(vis)->clipbr.y = bottom;
	LIBGGI_GC(vis)->version++;

	if (vis->opgc->gcchanged != NULL) {
		vis->opgc->gcchanged(vis, GGI_GCCHANGED_CLIP);
	}

	return 0;
}


int ggiGetGCClipping(ggi_visual_t vis,int *left,int *top,int *right,int *bottom)
{
	*left   = LIBGGI_GC(vis)->cliptl.x;
	*top    = LIBGGI_GC(vis)->cliptl.y;
	*right  = LIBGGI_GC(vis)->clipbr.x;
	*bottom = LIBGGI_GC(vis)->clipbr.y;

	return 0;
}
