/* 
 *  2D Graphics library for GGI.
 *
 *  Copyright (C) 1998 Thomas Tanner <tanner@ggi-project.org>
 *  Copyright (C) 1997 Todd Fries - toddf@acm.org
 *  Modifications for SGI architecture by Emmanuel Marty <core@mirus.fr>
 * 
 *  If you do any modifications, I would like you to send diffs to me
 *  to allow for collecting a more and more complete set of drivers and
 *  to improve existing ones.
 * 
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include <stdio.h>
#include <stdarg.h>

#include <debug.h>

extern int ggiDebugState;

#ifdef __sgi

void PASSERT(int x, char *arg, ...) {
	va_list args;

	if (!ggiDebugState) return;

	if (!x) {
		va_start(args, arg);

		fprintf (stderr, "assertion %s failed.", x);
		vfprintf (stderr, arg, args);
	}
}

void DEBUG0(char *arg, ...) {
	va_list args;

	if (!ggiDebugState) return;

	va_start(args, arg);
	vfprintf (stderr, arg, args);
}

void DEBUG1(char *arg, ...) {
	va_list args;

	if (!ggiDebugState) return;

	va_start(args, arg);
	vfprintf (stderr, arg, args);
}

void DEBUG2(char *arg, ...) {
	va_list args;

	if (!ggiDebugState) return;

	va_start(args, arg);
	vfprintf (stderr, arg, args);
}

void DEBUG3(char *arg, ...) {
	va_list args;

	if (!ggiDebugState) return;

	va_start(args, arg);
	vfprintf (stderr, arg, args);
}

void ERROR (char *format, ...) {
	va_list args;

	va_start(args, format);

	fprintf (stderr, "error : ");
	vfprintf (stderr, format, args);
	fprintf (stderr, "\n");
}

void debug_printf (char *form, ...) {
	va_list args;

	va_start(args, form);
	vfprintf (stderr, form, args);
}

#endif /* #ifdef __sgi */

void _DPRINT(const char *file,int line, const char *form,...) {
	va_list args;

	if (ggiDebugState>0) {
		va_start(args, form);
		fprintf(stderr,"%s:%i: ",file,line);
		vfprintf(stderr,form,args);
		va_end(args);
		fflush(stderr);
	}
}
