/* 
 *  horizontal line drawing
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

void	GGIEXP(drawHLine_NOOP)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
}

void	GGIEXP(drawHLine_INVERT)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
	ggi_sint	width;
	pixel	*ptr;
    
	CLIPHLINE(vis, x1, x2, y, width);
	ptr	= LFBADDR(vis, x1, y);
	width	= x2 - x1 + 1;
	while (width--) { *ptr = ~*ptr; ptr++; }
}

static void drawHLine(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y, pixel color)
{
	ggi_sint	width;
	pixel	*ptr;
	
	CLIPHLINE(vis, x1, x2, y, width);
	ptr	= LFBADDR(vis, x1, y);
	width	= x2 - x1 + 1;
	switch (GGI2D_GC_OP(vis)) {
	
#define	DRAWHLINE(OP,EXPR) \
	case GGI2D_ ## OP: while (width--) { *ptr = EXPR; ptr++; } break;

	case GGI2D_NOOP: 
	case GGI2D_INVERT: 
	case GGI2D_SET: memset(ptr, color, width); break;
	case GGI2D_SET_INVERTED: memset(ptr, ~color, width); break;
	DRAWHLINE(AND, *ptr & color )
	DRAWHLINE(NAND, ~(*ptr & color) )
	DRAWHLINE(AND_REVERSE, ~*ptr & color )
	DRAWHLINE(AND_INVERTED, *ptr & ~color )
	DRAWHLINE(OR, *ptr | color )
	DRAWHLINE(NOR, ~(*ptr | color) )
	DRAWHLINE(OR_REVERSE, ~*ptr | color )
	DRAWHLINE(OR_INVERTED, *ptr | ~color )
	DRAWHLINE(XOR, *ptr ^ color )
	DRAWHLINE(EQUIV, ~(*ptr ^ color) )
	DRAWHLINE(ADD, *ptr + color )
	DRAWHLINE(SUB, *ptr - color )
	}
}

void	GGIEXP(scanline)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
	drawHLine(vis, x1, x2, y, GGI2D_GC_FILLCOL(vis));
}

void	GGIEXP(hLine)(ggi_visual_t vis, ggi_sint x1, ggi_sint x2, ggi_sint y)
{
	drawHLine(vis, x1, x2, y, GGI2D_GC_DRAWCOL(vis));
}

/*----------------------------------------------------------------------*/
