/* 
 *  setup
 *
 *  Copyright (C) 1998 Thomas Tanner. See CREDITS for details.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "lib.h"
#include "util.h"

/*----------------------------------------------------------------------*/

static void	update(ggi_visual_t vis, ggi_uint change)
{
	ggi2d_funcs *func = GGI2D_FUNC(vis);
	int	textured = GGI2D_GC_TEXTURED(vis);
	int	dashed = GGI2D_GC_DASHSIZE(vis);

	DPRINT("updating 2d stubs\n");

	func->putPixel = GGIEXP(putPixel);
	func->drawPixel = GGIEXP(drawPixel);
	if (textured)
		func->fillPixel = GGIEXP(fillPixel)[0];
	else
		func->fillPixel = GGIEXP(fillPixel)[1];
	func->scanline = GGIEXP(scanline);
	func->drawPixels = GGIEXP(drawPixels);
	func->scanlines = GGIEXP(scanlines);
	func->fillRect = GGIEXP(fillRect);
	func->drawLines = GGIEXP(drawLines);
	if (dashed) {
		func->hLine = GGIEXP(hLine)[0];
		func->vLine = GGIEXP(vLine)[0];
		func->drawRect = GGIEXP(drawRect)[0];
		func->drawPoly = GGIEXP(drawPoly)[0];
		func->line = GGIEXP(line)[0];
		func->drawArc = GGIEXP(drawArc)[0];
		func->drawCircle = GGIEXP(drawCircle)[0];
		func->drawEllipse = GGIEXP(drawEllipse)[0];
		func->drawArc = GGIEXP(drawArc)[0];
		func->bezier = GGIEXP(bezier)[0];
		func->drawPoly = GGIEXP(drawPoly)[0];
	} else {
		func->hLine = GGIEXP(hLine)[1];
		func->vLine = GGIEXP(vLine)[1];
		func->drawRect = GGIEXP(drawRect)[1];
		func->drawPoly = GGIEXP(drawPoly)[1];
		func->line = GGIEXP(line)[1];
		func->drawArc = GGIEXP(drawArc)[1];
		func->drawCircle = GGIEXP(drawCircle)[1];
		func->drawEllipse = GGIEXP(drawEllipse)[1];
		func->drawArc = GGIEXP(drawArc)[1];
		func->bezier = GGIEXP(bezier)[1];
		func->drawPoly = GGIEXP(drawPoly)[1];
	}
	func->fillCircle = GGIEXP(fillCircle);
	func->fillEllipse = GGIEXP(fillEllipse);
	func->fillArc = GGIEXP(fillArc);
	func->trapezoid = GGIEXP(trapezoid);
	func->triangle = GGIEXP(triangle);
	func->fillPoly = GGIEXP(fillPoly);
	func->fillPolys = GGIEXP(fillPolys);
	func->blit = GGIEXP(blit);
	func->blitOp = GGIEXP(blitOp);
	func->stretchBlit = GGIEXP(stretchBlit);
	func->stretchBlitOp = GGIEXP(stretchBlitOp); 
}

int GGILIB_INIT(ggi_visual_t visual,const char *version)
{
	DPRINT("initializing 2d stubs\n");
	GGI2DregisterUpdateFunc(visual, update, 
		GGI2D_UPD_ARCMODE + 
		GGI2D_UPD_POLYMODE + 
		GGI2D_UPD_LINEMODE + 
		GGI2D_UPD_APPENDMODE + 
		GGI2D_UPD_TEXTUREMODE + 
		GGI2D_UPD_OPERATOR);
	return 0;
}

int GGILIB_CLEANUP(ggi_visual_t visual)
{
	return 0;
}
		
/*----------------------------------------------------------------------*/
