/* $Id: dl.c,v 1.2 1998/10/24 04:04:06 marcus Exp $
***************************************************************************

   Input library for GGI. Library extensions dynamic loading.

   Copyright (C) 1997 Jason McMullan	[jmcc@ggi-project.org]

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
  
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***************************************************************************
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef _WIN32
#include <windows.h> 
#define GIIOPENLIB(filename)	LoadLibrary((filename))
#define GIIOPENLIBGLOBAL(filename) GIIOPENLIB(filename)
#define GIIGETSYM(handle,sym)	GetProcAddress((handle),(sym))
#define GIICLOSELIB(handle)	FreeLibrary((handle))
#else /* _WIN32 */

#include <dlfcn.h>
#ifdef RTLD_LAZY
#define GIIOPENLIB(filename)		dlopen((filename), RTLD_LAZY)
#ifdef RTLD_GLOBAL
#define GIIOPENLIBGLOBAL(filename)	dlopen((filename), RTLD_LAZY | RTLD_GLOBAL)
#else
#define GIIOPENLIBGLOBAL(filename)	dlopen((filename), RTLD_LAZY)
#endif /* RTLD_GLOBAL */
#elif defined(DL_LAZY)
#define GIIOPENLIB(filename)		dlopen((filename), DL_LAZY)
#define GIIOPENLIBGLOBAL(filename)	dlopen((filename), DL_LAZY)
#else
#error This system has an unknown dlopen() call !!!
#endif /* RTLD_LAZY */
#define GIIGETSYM(handle,sym)	dlsym((handle),(sym))
#define GIICLOSELIB(handle)	dlclose((handle))
#endif /* _WIN32 */

#ifdef __OpenBSD__
#define GII_SYMPREFIX		"_"
#else
#define GII_SYMPREFIX		""
#endif

#define GII_DLINIT_SYM		GII_SYMPREFIX##"GIIdlinit"

#include <ggi/internal/gii.h>

/* Open the dynamic libary requested
 */
gii_dlhandle *_giiLoadDL(const char *filename)
{
	gii_dlhandle hand,*hp;

	DPRINT_LIBS("_giiLoadDL(\"%s\") called \n", filename);

	hand.handle=GIIOPENLIB(filename);

	DPRINT_LIBS("hand.handle=%p\n",hand.handle);
	if (hand.handle==NULL) 
		return NULL;

	hand.init=(int (*)(struct gii_input *, const char *))  GIIGETSYM(hand.handle,GII_DLINIT_SYM);

	DPRINT_LIBS("hand.init=%p\n",hand.init);
	if (hand.init == NULL ||
	    (hp = (gii_dlhandle *) malloc(sizeof(gii_dlhandle))) == NULL) {
		GIICLOSELIB(hand.handle);
		return NULL;
	}
	memcpy(hp, &hand, sizeof(gii_dlhandle));

	return hp;
}
