/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#include <stdio.h>

#include "wnlib.h"
#include "wnmem.h"
#include "wnasrt.h"
#include "wnrndd.h"

#include "wnbtr.h"
#include "wnbtrl.h"



#if 1

#define SIZE  100000


void main(void)
{
  wn_btree tree;
  wn_bhandle handle;
  int i,num,count,index,index2;
  
  wn_gpmake("general_free");

  printf("testing wnbtr...\n");

  wn_mkintbtree(&tree);
  wn_bverify(tree);

  for(i=0;i<SIZE;i++)
  {
    /*
    num = wn_random_int_between(0,1000000);
    num = 1;
    */
    num = i;
    wn_bins(&handle,tree,(ptr)num);
    handle->contents = (ptr)(num+1);
  }

  wn_bverify(tree);

  for(i=0;i<SIZE;i++)
  {
    num = i;
    wn_bget(&handle,tree,(ptr)num,WN_B_EQ);
    wn_assert((int)(handle->contents) == num+1);
  }

  for(i=0;i<SIZE;i++)
  {
    count = wn_bcount(tree);
    wn_assert(count > 0);

    index = wn_random_int_between(0,count);
    wn_bget_handle_of_index(&handle,tree,index);
    wn_bget_index_of_handle(&index2,tree,handle);
    wn_assert(index == index2);
    wn_bdel(handle,tree);
  }

  wn_bverify(tree);

  count = wn_bcount(tree);
  wn_assert(count == 0);

  wn_bverify(tree);
  printf(" ok!!!!!!\n");

  wn_gpfree();

  exit(0);
}
#endif



